/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ******************************************************************/
package com.sap.cds.jdbc.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

public interface SessionVariableSetter {
	
	void set(Connection conn, String key, String value) throws SQLException;

	default void set(Connection conn, Map<String, String> contextVariables) throws SQLException {
		Set<Entry<String, String>> entrySet = contextVariables.entrySet();
		for (Entry<String, String> setting : entrySet) {
			set(conn, setting.getKey(), setting.getValue());
		}
	}

}
