/************************************************************************
 * © 2021-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.UnaryOperator;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;

@Beta
public interface DbContext {

	TableNameResolver createTableNameResolver(Locale locale);

	SearchResolver createSearchResolver(CdsModel model, Locale locale);

	FunctionMapper getFunctionMapper();

	StatementResolver getStatementResolver();

	ExceptionAnalyzer getExceptionAnalyzer();

	Capabilities getCapabilities();

	UnaryOperator<CqnPredicate> getPredicateMapper();

	ValueBinder getBinder(TimeZone timeZone);
	
	SessionVariableSetter getSessionVariableSetter();

	default Function<String, String> casing() {
		return name -> name.toUpperCase(Locale.US);
	}

	SqlMapping getSqlMapping(CdsStructuredType rowType);

}
