/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnLock.Mode;

@Beta
public interface StatementResolver {

	default Optional<String> collateClause(Locale locale) {
		return Optional.empty();
	}

	default Optional<String> collateClause(CqnStatement statement, Locale locale) {
		return collateClause(locale);
	}

	default String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns,
			Stream<String> upsertValues) {
		throw new UnsupportedOperationException("Upsert is not supported on this data store");
	}
	
	default String lockMode(Mode mode) {
			return "FOR UPDATE";
	}
	
	default Optional<String> timeoutClause(int timeoutSeconds) {
		return Optional.empty();
	}
	
	default Stream<String> lockClause(CqnLock lock) {
		Stream.Builder<String> stream = Stream.builder();
		stream.add(lockMode(lock.mode()));
		lock.timeout().ifPresent(to -> timeoutClause(to).ifPresent(stream::add));
		
		return stream.build();
	}

	default Optional<String> hints(Map<String, Object> hints) {
		return Optional.empty();
	}
}
