/************************************************************************
 * © 2021-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.google.common.annotations.Beta;
import com.sap.cds.reflect.CdsBaseType;

@Beta
public interface ValueBinder {

	<T> Getter<T> getter(CdsBaseType cdsType, boolean isMediaType);

	Setter setter(CdsBaseType cdsType);

	<T> T getValue(ResultSet result, int i, CdsBaseType cdsType, boolean isMediaType) throws SQLException;

	void setValue(PreparedStatement pstmt, int i, CdsBaseType cdsType, Object value) throws SQLException;

	interface Getter<T> {
		T get(ResultSet r, int i) throws SQLException;
	}

	interface Setter {
		void set(PreparedStatement pstmt, int i, Object value) throws SQLException;
	}

}
