/************************************************************************
 * © 2021-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;

@Beta
public interface DbContext {

	TableNameResolver createTableNameResolver(Locale locale);

	SearchResolver createSearchResolver(CdsModel model, Locale locale, CqnSelect select);

	FunctionMapper getFunctionMapper();

	StatementResolver getStatementResolver();

	ExceptionAnalyzer getExceptionAnalyzer();

	Capabilities getCapabilities();

	PredicateMapper getPredicateMapper();

	ValueBinder getBinder(TimeZone timeZone);

	SessionVariableSetter getSessionVariableSetter();

	default Function<String, String> casing() {
		return name -> name.toUpperCase(Locale.US);
	}

	SqlMapping getSqlMapping(CdsStructuredType rowType);

}
