/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.spi;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.common.annotations.Beta;

/**
 * Analyzes vendor codes to identify particular exceptions, like timeout, unique
 * and not null constraint violation exceptions.
 */

@Beta
public interface ExceptionAnalyzer {

	boolean isUniqueConstraint(SQLException ex);

	boolean isNotNullConstraint(SQLException ex);

	boolean isLockTimeout(SQLException ex);

	/**
	 * Returns the root cause of an exception
	 * 
	 * @param throwable exception to walk through to a root cause
	 * @return root cause
	 */
	static Throwable getRootCause(final Throwable throwable) {
		Throwable t = throwable;
		final List<Throwable> causeChain = new ArrayList<>();
		while (t != null && !causeChain.contains(t)) {
			causeChain.add(t);
			t = t.getCause();
		}
		return causeChain.isEmpty() ? null : causeChain.get(causeChain.size() - 1);
	}
}
