/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.stream.Stream;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;

/**
 * This class is associated with an underlying structured type and provides the
 * mapping of the type and its elements to table and column names.
 *
 * Provides the mapping of the elements of an underlying structured type.
 */
public interface SqlMapping {

	String tableName();

	String localizedViewName();

	String plainTableName(String qualifiedEntityName);

	String columnName(String elementName);

	String columnName(CqnElementRef ref);

	String columnName(Stream<? extends CqnReference.Segment> segments);

	String columnName(CdsElement element);

	String jsonObjectPath(CqnElementRef ref);

	CdsStructuredType getRowType();

	String delimitedCasing(String undelimited);

	String columnLikeAlias(CdsElement element);

	String cteName();

}
