/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.spi;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Beta
public interface StatementResolver {
    default public Optional<String> collate(Locale locale) {
        return Optional.empty();
    }

    default public Optional<String> collate(CqnSortSpecification o, Locale locale) {
        return this.collate(locale);
    }

    default public Optional<String> statementWideCollation(CqnSelect select, Locale locale) {
        return Optional.empty();
    }

    default public boolean supportsStatementWideCollation() {
        return false;
    }

    default public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        throw new UnsupportedOperationException("Upsert is not supported on this data store");
    }

    default public String lockMode(CqnLock.Mode mode) {
        return "FOR UPDATE";
    }

    default public Optional<String> timeoutClause(int timeoutSeconds) {
        return Optional.empty();
    }

    default public Stream<String> lockClause(CqnLock lock) {
        Stream.Builder<String> stream = Stream.builder();
        stream.add(this.lockMode(lock.mode()));
        lock.timeout().ifPresent(to -> this.timeoutClause((int)to).ifPresent(stream::add));
        return stream.build();
    }

    default public String deleteAll(String tableName) {
        return "DELETE FROM " + tableName;
    }

    default public Optional<String> hints(Map<String, Object> hints) {
        return Optional.empty();
    }

    default public CqnSelect preOptimize(CqnSelect select) {
        return select;
    }
}

