/************************************************************************
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.CqnTableFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;

@Beta
public interface DbContext {

	TableNameResolver createTableNameResolver(Locale locale);

	SearchResolver createSearchResolver(CdsModel model, Locale locale, Map<String, Object> hints);

	FunctionMapper getFunctionMapper();

	StatementResolver getStatementResolver();

	ExceptionAnalyzer getExceptionAnalyzer();

	Capabilities getCapabilities();

	PredicateMapper getPredicateMapper();

	ValueBinder getBinder(TimeZone timeZone);

	SessionVariableSetter getSessionVariableSetter();

	default Function<String, String> casing() {
		return name -> name.toUpperCase(Locale.US);
	}

	SqlMapping getSqlMapping(CdsStructuredType rowType);

	ScalarValueResolver getScalarValueResolver();
	
	default DbContext subDialect(String name) {
		return this;
	}

	default TableFunctionMapper getTableFunctionMapper(Object context, List params, CqnTableFunction tableFunction) {
		throw new UnsupportedOperationException("Table function %s not supported".formatted(tableFunction.name()));
	}

}
