/************************************************************************
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsStructuredType;

/**
 * Resolves the CQN search predicate of a given select into a datastore specific
 * predicate.
 */
@Beta
public interface SearchResolver {

	CqnSelect resolve(CqnSelect select);

	// TODO get rid of this or push to AbstractSearchResolver
	default void pushDownSearchToSubquery(CqnSelect select, CqnSelect subquery) {
	}

	default CqnPredicate resolve(CqnPredicate searchExpression, CdsStructuredType searchTarget, boolean exactSearch) {
		return searchExpression;
	}
}
