/************************************************************************
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.reflect.CdsBaseType;

public interface ScalarValueResolver {
	
	String literal(CqnBooleanLiteral bool);

	default String literal(CqnLiteral<?> literal) {
		return "?";
	}
	
	default String parameter(CqnVector vector) {
		return "?";
	}

	default String parameter(CqnParameter p) {
		return "?";
	}

	default String parameter(CdsBaseType type) {
		return "?";
	}

	default CqnValue selectListValue(CqnValue value) {
		return value;
	}

}
