/**************************************************************************
 * (C) 2023-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.stream.Stream;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;

/**
 * This class is associated with an underlying structured type and provides the
 * mapping of the type and its elements to table and column names.
 *
 * Provides the mapping of the elements of an underlying structured type.
 */
public interface SqlMapping {

	String tableName();

	String localizedViewName();

	String plainTableName(String qualifiedEntityName);

	String columnName(String elementName);

	String columnName(CqnElementRef ref);

	String columnName(Stream<? extends CqnReference.Segment> segments);

	String columnName(CdsElement element);

	CdsStructuredType getRowType();

	String delimitedCasing(String undelimited);

	String columnLikeAlias(CdsElement element);

	String cteName();

	/**
	 * Maps a JSON path query for extracting serialized JSON text from a JSON
	 * context to the DB specific representation.
	 *
	 * @param contextItem specifies the JSON document to operate on, such as a table
	 *                    column, string, or collection.
	 * @param jsonPath    the JSON path expression to extract the value. Array
	 *                    indexes start from 0, rather than 1 (the SQL standard).
	 * @return the DB specific representation of the JSON path query
	 */
	@Beta
	String jsonQuery(String contextItem, String jsonPath);

	/**
	 * Maps a JSON path query for extracting scalar values from a JSON context to
	 * the DB specific representation.
	 *
	 * @param contextItem specifies the JSON document to operate on, such as a table
	 *                    column, string, or collection.
	 * @param jsonPath    the JSON path expression to extract the value. Array
	 *                    indexes start from 0, rather than 1 (the SQL standard).
	 * @param type        the expected type of the extracted value.
	 * @return the DB specific representation of the JSON value
	 */
	@Beta
	String jsonValue(String contextItem, String jsonPath, CdsBaseType type);

}
