/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.spi;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CqnTableFunction;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;

@Beta
public interface DbContext {
    public TableNameResolver createTableNameResolver(Locale var1);

    public SearchResolver createSearchResolver(CdsModel var1, Locale var2, Map<String, Object> var3);

    public FunctionMapper getFunctionMapper();

    public StatementResolver getStatementResolver();

    public ExceptionAnalyzer getExceptionAnalyzer();

    public CdsDataStoreConnector.Capabilities getCapabilities();

    public PredicateMapper getPredicateMapper();

    public ValueBinder getBinder(TimeZone var1);

    public SessionVariableSetter getSessionVariableSetter();

    default public Function<String, String> casing() {
        return name -> name.toUpperCase(Locale.US);
    }

    public SqlMapping getSqlMapping(CdsStructuredType var1);

    public ScalarValueResolver getScalarValueResolver();

    default public DbContext subDialect(String name) {
        return this;
    }

    default public TableFunctionMapper getTableFunctionMapper(Object context, List params, CqnTableFunction tableFunction, Map<String, ?> ctes) {
        throw new UnsupportedOperationException("Table function %s not supported".formatted(tableFunction.name()));
    }
}

