/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.mvn;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import com.sap.cds.generator.Cds4jCodegen;
import com.sap.cds.generator.Cds4jCodegen.Result;
import com.sap.cds.generator.Cds4jCodegen.Result.Status;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.ConfigurationImpl;
import com.sap.cds.generator.util.FileSystem;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;

/**
 * @deprecated instead use com.sap.cds:cds-maven-plugin
 */
@Mojo(name = "generate", defaultPhase = LifecyclePhase.GENERATE_SOURCES, threadSafe = false, requiresProject = false)
public class Cds4jCodeGeneratorPlugin extends AbstractMojo {

	@Parameter(property = "csnFile", required = true)
	private String csnFile;

	@Parameter(property = "outputDirectory", required = false, defaultValue = "src/gen")
	private String outputDirectory;

	@Parameter(property = "parserMode", required = false, defaultValue = "tolerant")
	private String parserMode;

	@Parameter(property = "generatorMode", required = false, defaultValue = "tolerant")
	private String generatorMode;

	@Parameter(property = "methodStyle", required = false, defaultValue = "BEAN")
	private String methodStyle;

	@Parameter(property = "basePackage", required = false)
	private String basePackage;

	@Parameter(property = "eventContext", required = false, defaultValue = "false")
	private String eventContext;

	@Parameter(property = "excludes", required = false, defaultValue = "")
	private List<String> excludes;

	@Override
	public void execute() throws MojoFailureException {
		Configuration cfg = createConfig();
		Result result;
		final Log logger = getLog();

		try {
			GeneratedFile.Accessor fs = new FileSystem(Paths.get(outputDirectory), true);
			result = new Cds4jCodegen(cfg).generate(() -> Files.readAllBytes(Paths.get(csnFile)), fs);

		} catch (Exception e) { // NOSONAR: catch all exceptions
			logger.error(e);
			throw new MojoFailureException("Failed to generate Java classes: ", e);
		}

		if (result.getStatus() == Status.SUCCESS) {
			logger.info("Class generation finished successfully");
		} else {
			logger.error("Class generation failed");
		}

		result.getIssues().stream().forEach(issue -> {
			String msg = String.format("[%s] %s : %s", issue.getType(), issue.getLocation(), issue.getMessage());
			if ((issue.getType() == IssueType.CRITICAL)
					|| (issue.getType() == IssueType.ERROR && cfg.getGeneratorMode() == GeneratorMode.STRICT)) {
				logger.error(msg);
			} else {
				logger.warn(msg);
			}
		});

		if (result.getStatus() == Status.FAILURE) {
			throw new MojoFailureException("Failed to generate Java classes");
		}
	}

	private Configuration createConfig() {
		ConfigurationImpl cfg = new ConfigurationImpl();
		setIfNotNull(cfg::setParserMode, parserMode);
		setIfNotNull(cfg::setGeneratorMode, generatorMode);
		setIfNotNull(cfg::setMethodStyle, methodStyle);
		setIfNotNull(cfg::setBasePackage, basePackage);
		setIfNotNull(cfg::setEventContext, eventContext);
		setIfNotNull(cfg::setExcludes, excludes);
		return cfg;
	}

	private <T> void setIfNotNull(Consumer<T> setter, T value) {
		if (value != null) {
			setter.accept(value);
		}
	}
}
