/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mvn;

import com.sap.cds.generator.Cds4jCodegen;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.ConfigurationImpl;
import com.sap.cds.generator.util.FileSystem;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=false, requiresProject=false)
public class Cds4jCodeGeneratorPlugin
extends AbstractMojo {
    @Parameter(property="csnFile", required=true)
    private String csnFile;
    @Parameter(property="outputDirectory", required=false, defaultValue="src/gen")
    private String outputDirectory;
    @Parameter(property="parserMode", required=false, defaultValue="tolerant")
    private String parserMode;
    @Parameter(property="generatorMode", required=false, defaultValue="tolerant")
    private String generatorMode;
    @Parameter(property="methodStyle", required=false, defaultValue="BEAN")
    private String methodStyle;
    @Parameter(property="basePackage", required=false)
    private String basePackage;
    @Parameter(property="eventContext", required=false, defaultValue="false")
    private String eventContext;
    @Parameter(property="excludes", required=false, defaultValue="")
    private List<String> excludes;

    public void execute() throws MojoFailureException {
        Cds4jCodegen.Result result;
        Configuration cfg = this.createConfig();
        Log logger = this.getLog();
        try {
            FileSystem fs = new FileSystem(Paths.get(this.outputDirectory, new String[0]), true);
            result = new Cds4jCodegen(cfg).generate(() -> Files.readAllBytes(Paths.get(this.csnFile, new String[0])), (GeneratedFile.Consumer)fs);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new MojoFailureException("Failed to generate Java classes: ", (Throwable)e);
        }
        if (result.getStatus() == Cds4jCodegen.Result.Status.SUCCESS) {
            logger.info((CharSequence)"Class generation finished successfully");
        } else {
            logger.error((CharSequence)"Class generation failed");
        }
        result.getIssues().stream().forEach(issue -> {
            String msg = String.format("[%s] %s : %s", issue.getType(), issue.getLocation(), issue.getMessage());
            if (issue.getType() == IssueType.CRITICAL || issue.getType() == IssueType.ERROR && cfg.getGeneratorMode() == GeneratorMode.STRICT) {
                logger.error((CharSequence)msg);
            } else {
                logger.warn((CharSequence)msg);
            }
        });
        if (result.getStatus() == Cds4jCodegen.Result.Status.FAILURE) {
            throw new MojoFailureException("Failed to generate Java classes");
        }
    }

    private Configuration createConfig() {
        ConfigurationImpl cfg = new ConfigurationImpl();
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setParserMode(arg_0), this.parserMode);
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setGeneratorMode(arg_0), this.generatorMode);
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setMethodStyle(arg_0), this.methodStyle);
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setBasePackage(arg_0), this.basePackage);
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setEventContext(arg_0), this.eventContext);
        this.setIfNotNull(arg_0 -> ((ConfigurationImpl)cfg).setExcludes(arg_0), this.excludes);
        return cfg;
    }

    private <T> void setIfNotNull(Consumer<T> setter, T value) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

