package com.sap.cds.mtx.impl;

import java.util.function.Function;

import javax.sql.DataSource;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.impl.JDBCDataStoreConnector;
import com.sap.cds.mtx.CdsDataStoreConnectorCreator;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.transaction.TransactionManager;

public class CdsDataStoreConnectorCreatorImpl implements CdsDataStoreConnectorCreator {
	private final MetaDataAccessor<?> metaDataAccessor;
	private final Function<String, DataSource> dataSourceForTenant;
	private final TransactionManager cdsTransactionManager;

	public CdsDataStoreConnectorCreatorImpl(MetaDataAccessor<?> metaDataAccessor,
			Function<String, DataSource> dataSourceForTenant, TransactionManager cdsTransactionManager) {
		this.metaDataAccessor = metaDataAccessor;
		this.dataSourceForTenant = dataSourceForTenant;
		this.cdsTransactionManager = cdsTransactionManager;
	}

	@Override
	public CdsDataStoreConnector create(String tenantId) {
		return new JDBCDataStoreConnector(metaDataAccessor.getCdsModel(tenantId), dataSourceForTenant.apply(tenantId),
				cdsTransactionManager);
	}
}
