/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsCommunicationException;

/**
 * Class providing access to JWT tokens, a retrieved JWT is cached until it
 * expires
 */
public class ClientCredentialJwtAccess {
	private final ClientCredentialJwtReader jwtReader;
	// response is buffered as long as JWT is valid
	private volatile ClientCredentialJwtReader.Response response;

	/**
	 *
	 * @param jwtReader object that retrieves a new JWT from XSUAA
	 */
	public ClientCredentialJwtAccess(ClientCredentialJwtReader jwtReader) {
		this.jwtReader = jwtReader;
	}

	/**
	 * Returns a valid JWT
	 * 
	 * @return the JWT as string
	 * @throws CdsCommunicationException
	 */
	public String getJwt() throws CdsCommunicationException {
		// see double checked locking for this pattern
		ClientCredentialJwtReader.Response localRef = response;
		if (localRef == null || !localRef.isValid()) {
			synchronized (this) {
				localRef = response;
				if (localRef == null || !localRef.isValid()) {
					response = localRef = jwtReader.getJwt();
				}
			}
		}

		return localRef.getAccessToken();
	}

}
