package com.sap.cds.mtx.impl;

import java.util.function.BiPredicate;

import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.reflect.CdsModel;

public class ModelOutDatedChecker implements BiPredicate<String, CdsModel> {
	private final MetaDataAccessor<?> metaDataAccessor;

	public ModelOutDatedChecker(MetaDataAccessor<?> metaDataAccessor) {
		this.metaDataAccessor = metaDataAccessor;
	}

	@Override
	public boolean test(String tenantId, CdsModel cdsModel) {
		return metaDataAccessor.getCdsModel(tenantId) != cdsModel;
	}
}
