/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mt.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class ProxyCreator {
    public static <T> T create(Class<T> clazz, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    public static <T> ProxyBuilder<T> proxy(Class<T> clazz, T instance) {
        return new ProxyBuilder<T>(clazz, instance);
    }

    public static class ProxyBuilder<T> {
        private final Class<T> clazz;
        private final T instance;
        Map<String, Object> substitutes = new HashMap<String, Object>();

        public ProxyBuilder(Class<T> clazz, T instance) {
            this.clazz = clazz;
            this.instance = instance;
        }

        public ProxyBuilder<T> overwrite(String methodName, Object value) {
            this.substitutes.put(methodName, value);
            return this;
        }

        public T create() {
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object substitute = substitutes.get(method.getName());
                    if (substitute != null) {
                        return substitute;
                    }
                    return method.invoke(instance, args);
                }
            };
            return ProxyCreator.create(this.clazz, invocationHandler);
        }
    }
}

