/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsException;
import java.util.concurrent.TimeUnit;

public class CacheParams {
    private final long maximumSize;
    private final long expirationDuration;
    private final TimeUnit expirationDurationUnit;
    private final long refreshDuration;
    private final TimeUnit refreshDurationUnit;
    private final boolean synchronousRefresh;

    public CacheParams(long maximumSize, long expirationDuration, TimeUnit expirationDurationUnit, long refreshDuration, TimeUnit refreshDurationUnit) throws CdsException {
        this(maximumSize, expirationDuration, expirationDurationUnit, refreshDuration, refreshDurationUnit, false);
    }

    public CacheParams(long maximumSize, long expirationDuration, TimeUnit expirationDurationUnit, long refreshDuration, TimeUnit refreshDurationUnit, boolean synchronousRefresh) throws CdsException {
        this.synchronousRefresh = synchronousRefresh;
        if (maximumSize < 0L) {
            throw new CdsException("Maximum cache size must be greater than or equal to 0");
        }
        if (expirationDuration < 0L) {
            throw new CdsException("Expiration duration must be positive");
        }
        if (expirationDurationUnit == null) {
            throw new CdsException("Expiration duration unit must not be null");
        }
        if (refreshDuration <= 0L) {
            throw new CdsException("Refresh duration must be greater than 0");
        }
        if (refreshDurationUnit == null) {
            throw new CdsException("Refresh duration unit must not be null");
        }
        this.maximumSize = maximumSize;
        this.expirationDuration = expirationDuration;
        this.expirationDurationUnit = expirationDurationUnit;
        this.refreshDuration = refreshDuration;
        this.refreshDurationUnit = refreshDurationUnit;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public long getExpirationDuration() {
        return this.expirationDuration;
    }

    public TimeUnit getExpirationDurationUnit() {
        return this.expirationDurationUnit;
    }

    public long getRefreshDuration() {
        return this.refreshDuration;
    }

    public TimeUnit getRefreshDurationUnit() {
        return this.refreshDurationUnit;
    }

    public boolean isSynchronousRefresh() {
        return this.synchronousRefresh;
    }
}

