package com.sap.cds.mtx.impl;

/**
 * Value class containing parameters of xsuua service instance
 */
public class XsuaaParams {
    private final String url;
    private final String clientId;
    private final String clientSecret;

    /**
     * @param url          URL of xsuaa service instance (stored in VCAP_SERVICES)
     * @param clientId     client id  (stored in VCAP_SERVICES)
     * @param clientSecret client secret  (stored in VCAP_SERVICES)
     */
    public XsuaaParams(String url, String clientId, String clientSecret) {
        this.url = url;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    /**
     * @return URL
     */
    public String getUrl() {
        return url;
    }

    /**
     * @return client id
     */
    public String getClientId() {
        return clientId;
    }

    /**
     * @return client secret
     */
    public String getClientSecret() {
        return clientSecret;
    }
}
