/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import java.time.Instant;

public class ClientCredentialJwtReader {
    private final XsuaaTokenFlows tokenFlows;

    public ClientCredentialJwtReader(XsuaaParams xsuaaParams) {
        this.tokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService(), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(xsuaaParams.getUrl()), new ClientCredentials(xsuaaParams.getClientId(), xsuaaParams.getClientSecret()));
    }

    public Response getJwt() throws CdsCommunicationException {
        try {
            OAuth2TokenResponse response = this.tokenFlows.clientCredentialsTokenFlow().execute();
            return new Response(response.getExpiredAt(), response.getAccessToken());
        }
        catch (TokenFlowException e) {
            throw new CdsCommunicationException("Could not retrieve JWT.", (Throwable)e);
        }
    }

    public static class Response {
        private final Instant expiredAt;
        private final String accessToken;

        public Response(Instant expiredAt, String accessToken) {
            this.expiredAt = expiredAt;
            this.accessToken = accessToken;
        }

        public boolean isValid() {
            return Instant.now().isBefore(this.expiredAt);
        }

        public String getAccessToken() {
            return this.accessToken;
        }
    }
}

