/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sap.cds.CdsException;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorImpl<M>
implements MetaDataAccessor<M> {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorImpl.class);
    private final SidecarAccess sidecarAccess;
    private final LoadingCache<String, CacheEntry<CdsModel>> tenantToCdsModel;
    private final LoadingCache<EdmxCacheKey, CacheEntry<M>> tenantToEdmxModel;
    private final EdmxModelCreator<M> strToEdmx;
    private final BiFunction<String, String, M> strToEdmxFunction;
    private static volatile ExecutorService executorService;

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, Ticker cacheTicker) {
        this(sidecarAccess, cacheParams, strToEdmx, null, cacheTicker);
    }

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, Ticker cacheTicker, BiFunction<String, String, M> strToEdmxFunction) {
        this(sidecarAccess, cacheParams, null, strToEdmxFunction, cacheTicker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, BiFunction<String, String, M> strToEdmxFunction, Ticker cacheTicker) {
        this.strToEdmx = strToEdmx;
        this.strToEdmxFunction = strToEdmxFunction;
        this.sidecarAccess = sidecarAccess;
        if (!cacheParams.isSynchronousRefresh() && executorService == null) {
            Class<MetaDataAccessorImpl> clazz = MetaDataAccessorImpl.class;
            // MONITORENTER : com.sap.cds.mtx.impl.MetaDataAccessorImpl.class
            if (executorService == null) {
                executorService = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : clazz
        }
        this.tenantToCdsModel = MetaDataAccessorImpl.buildCache(cacheParams, cacheTicker, this::loadCdsModel, executorService);
        this.tenantToEdmxModel = MetaDataAccessorImpl.buildCache(cacheParams, cacheTicker, this::loadEdmxModel, executorService);
    }

    private static <K, V> LoadingCache<K, V> buildCache(CacheParams params, Ticker cacheTicker, BiFunction<K, V, V> loader, ExecutorService executorService) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(params.getMaximumSize()).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit()).refreshAfterWrite(params.getRefreshDuration(), params.getRefreshDurationUnit());
        if (cacheTicker != null) {
            builder.ticker(cacheTicker);
        }
        if (params.isSynchronousRefresh()) {
            return builder.build(MetaDataAccessorImpl.getSynchronousLoader(loader));
        }
        return builder.build(MetaDataAccessorImpl.getAsynchronousLoader(loader, executorService));
    }

    public M getEdmx(String tenantId, String serviceName, String language) throws CdsException {
        try {
            return (M)((CacheEntry)this.tenantToEdmxModel.getUnchecked((Object)new EdmxCacheKey(tenantId, serviceName, language))).getEntry();
        }
        catch (UncheckedExecutionException e) {
            throw new CdsException((Throwable)e);
        }
    }

    public CdsModel getCdsModel(String tenantId) throws CdsException {
        try {
            return (CdsModel)((CacheEntry)this.tenantToCdsModel.getUnchecked((Object)tenantId)).getEntry();
        }
        catch (UncheckedExecutionException e) {
            throw new CdsException((Throwable)e);
        }
    }

    private CacheEntry<CdsModel> loadCdsModel(String tenantId, CacheEntry<CdsModel> oldEntry) {
        String eTag = oldEntry != null ? oldEntry.getETag() : null;
        ModelAndInformation csnModel = this.sidecarAccess.getCsn(tenantId, eTag);
        if (csnModel.isNotModified()) {
            return oldEntry;
        }
        return new CacheEntry<CdsModel>(CdsModelReader.read((String)csnModel.getModel(), (boolean)true), csnModel.getETag());
    }

    private CacheEntry<M> loadEdmxModel(EdmxCacheKey key, CacheEntry<M> oldEntry) {
        String eTag = oldEntry != null ? oldEntry.getETag() : null;
        ModelAndInformation edmxModel = this.sidecarAccess.getEdmx(key.getTenantId(), key.getServiceName(), key.getLanguage(), eTag);
        if (edmxModel.isNotModified()) {
            return oldEntry;
        }
        if (this.strToEdmx != null) {
            return new CacheEntry<M>(this.strToEdmx.parse(edmxModel.getModel(), key.getServiceName()), edmxModel.getETag());
        }
        return new CacheEntry<M>(this.strToEdmxFunction.apply(edmxModel.getModel(), key.getServiceName()), edmxModel.getETag());
    }

    public void refresh(String tenantId) {
        this.cacheActions(tenantId, arg_0 -> this.tenantToCdsModel.refresh(arg_0), arg_0 -> this.tenantToEdmxModel.refresh(arg_0));
    }

    public void evict(String tenantId) {
        this.cacheActions(tenantId, arg_0 -> this.tenantToCdsModel.invalidate(arg_0), arg_0 -> this.tenantToEdmxModel.invalidate(arg_0));
    }

    public void cacheActions(String tenantId, Consumer<String> cdsAction, Consumer<EdmxCacheKey> edmxAction) {
        Set tenants = this.tenantToCdsModel.asMap().keySet();
        tenants.stream().filter(k -> k.equals(tenantId)).forEach(cdsAction);
        Set keys = this.tenantToEdmxModel.asMap().keySet();
        keys.stream().filter(k -> ((EdmxCacheKey)k).tenantId.equals(tenantId)).forEach(edmxAction);
    }

    private static <K, V> CacheLoader<K, V> getAsynchronousLoader(final BiFunction<K, V, V> loader, final ExecutorService executorService) {
        return new CacheLoader<K, V>(){

            public V load(K key) {
                return loader.apply(key, null);
            }

            public ListenableFuture<V> reload(K key, V oldValue) {
                ListenableFutureTask readModelTask = ListenableFutureTask.create(() -> {
                    try {
                        return loader.apply(key, oldValue);
                    }
                    catch (Exception e) {
                        logger.error("Error when model was reread: {}", (Object)e.getMessage());
                        return oldValue;
                    }
                });
                executorService.execute((Runnable)readModelTask);
                return readModelTask;
            }
        };
    }

    private static <K, V> CacheLoader<K, V> getSynchronousLoader(final BiFunction<K, V, V> loader) {
        return new CacheLoader<K, V>(){

            public V load(K key) {
                return loader.apply(key, null);
            }

            public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
                Preconditions.checkNotNull(key);
                Preconditions.checkNotNull(oldValue);
                return Futures.immediateFuture(loader.apply(key, oldValue));
            }
        };
    }

    private static class EdmxCacheKey {
        private final String tenantId;
        private final String serviceName;
        private final String language;

        public EdmxCacheKey(String tenantId, String serviceName, String language) throws CdsException {
            if (Strings.isNullOrEmpty((String)tenantId)) {
                throw new CdsException("Tenant id must not be null");
            }
            this.tenantId = tenantId;
            this.serviceName = serviceName;
            this.language = language;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getLanguage() {
            return this.language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdmxCacheKey key = (EdmxCacheKey)o;
            return this.tenantId.equals(key.tenantId) && Objects.equals(this.serviceName, key.serviceName) && Objects.equals(this.language, key.language);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.serviceName, this.language);
        }
    }

    private static class CacheEntry<T> {
        private final T entry;
        private final String eTag;

        public CacheEntry(T entry, String eTag) {
            this.entry = entry;
            this.eTag = eTag.trim();
        }

        public T getEntry() {
            return this.entry;
        }

        public String getETag() {
            return this.eTag;
        }
    }

    @FunctionalInterface
    public static interface EdmxModelCreator<M> {
        public M parse(String var1, String var2);
    }
}

