/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.CdsException;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorSingleModelImpl<M>
implements MetaDataAccessor<M> {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorSingleModelImpl.class);
    private static final int BUFFER_SIZE = 1024;
    private final CdsModel cdsModel;
    private final String edmxFolder;
    private final ConcurrentHashMap<ServiceAndLanguage, M> keyToEdmx = new ConcurrentHashMap();
    private final BiFunction<String, String, M> edmxstrAndServiceToEdmxModel;

    public MetaDataAccessorSingleModelImpl(String cdsModelPath, String edmxFolder, BiFunction<String, String, M> edmxstrAndServiceToEdmxModel) throws IOException {
        if (cdsModelPath != null && !cdsModelPath.isEmpty()) {
            try (InputStream is = MetaDataAccessorSingleModelImpl.class.getClassLoader().getResourceAsStream(cdsModelPath);){
                if (is == null) {
                    throw new IOException("Cds model " + cdsModelPath + " not found");
                }
                this.cdsModel = CdsModelReader.read((InputStream)is);
            }
        } else {
            logger.warn("No model path provided");
            this.cdsModel = null;
        }
        this.edmxFolder = edmxFolder;
        this.edmxstrAndServiceToEdmxModel = edmxstrAndServiceToEdmxModel;
    }

    public M getEdmx(String tenantId, String serviceName, String language) throws CdsException {
        if (serviceName == null || serviceName.isEmpty()) {
            throw new CdsException("No service name specified");
        }
        if (language == null) {
            language = "";
        }
        ServiceAndLanguage key = new ServiceAndLanguage(language, serviceName);
        try {
            return (M)this.keyToEdmx.computeIfAbsent(key, this::readEmdxFromResource);
        }
        catch (RuntimeException e) {
            throw new CdsException((Throwable)e);
        }
    }

    private M readEmdxFromResource(ServiceAndLanguage key) throws RuntimeException {
        String edmxAsString;
        if (this.edmxstrAndServiceToEdmxModel == null) {
            throw new RuntimeException("No function to convert string into edmx model provided");
        }
        try (InputStream is = MetaDataAccessorSingleModelImpl.class.getClassLoader().getResourceAsStream(this.getResourceName(key.service, key.language));){
            if (is == null) {
                throw new IOException("Edmx file " + this.getResourceName(key.service, key.language) + " not found");
            }
            edmxAsString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.edmxstrAndServiceToEdmxModel.apply(edmxAsString, key.service);
    }

    private String getResourceName(String serviceName, String language) {
        String completePathStr = this.edmxFolder == null || this.edmxFolder.isEmpty() ? serviceName : this.edmxFolder + "/" + serviceName;
        if (language != null && !language.isEmpty()) {
            completePathStr = completePathStr + "_" + language.toLowerCase(Locale.ENGLISH);
        }
        completePathStr = completePathStr + ".xml";
        return completePathStr;
    }

    public CdsModel getCdsModel(String tenantId) throws CdsException {
        return this.cdsModel;
    }

    public void refresh(String tenantId) {
    }

    public void evict(String tenantId) {
    }

    private static class ServiceAndLanguage {
        private final String language;
        private final String service;

        public ServiceAndLanguage(String language, String service) {
            this.language = language;
            this.service = service;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceAndLanguage that = (ServiceAndLanguage)o;
            return Objects.equals(this.language, that.language) && this.service.equals(that.service);
        }

        public int hashCode() {
            return Objects.hash(this.language, this.service);
        }
    }
}

