/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Strings;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarAccess {
    private static final Logger logger = LoggerFactory.getLogger(SidecarAccess.class);
    private static final String CSN_PATH = "/mtx/v1/metadata/csn/";
    private static final String EDMX_PATH = "/mtx/v1/metadata/edmx/";
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHENTIFICATION_SCHEME = "Bearer";
    private static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private final String sidecarBaseUrl;
    private final ClientCredentialJwtAccess clientCredentialJwtAccess;
    private final AtomicReference<HttpDestination> atomicSidecarHttpDestination = new AtomicReference();

    public SidecarAccess(String sidecarBaseUrl, ClientCredentialJwtAccess clientCredentialJwtAccess) {
        this.sidecarBaseUrl = sidecarBaseUrl;
        this.clientCredentialJwtAccess = clientCredentialJwtAccess;
    }

    public ModelAndInformation getCsn(String tenantId, String eTag) throws CdsCommunicationException {
        return this.callSidecar(this.clientCredentialJwtAccess.getJwt(), this.getCsnUrl(tenantId), eTag);
    }

    public ModelAndInformation getEdmx(String tenantId, String serviceName, String language, String eTag) throws CdsCommunicationException {
        return this.callSidecar(this.clientCredentialJwtAccess.getJwt(), this.getEdmxUrl(tenantId, serviceName, language), eTag);
    }

    private String getCsnUrl(String tenantId) {
        return CSN_PATH + tenantId;
    }

    private String getEdmxUrl(String tenantId, String serviceName, String language) {
        String url = EDMX_PATH + tenantId;
        if (!Strings.isNullOrEmpty((String)serviceName)) {
            url = url + "?name=" + serviceName;
            if (!Strings.isNullOrEmpty((String)language)) {
                url = url + "&language=" + language;
            }
        } else if (!Strings.isNullOrEmpty((String)language)) {
            url = url + "?language=" + language;
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelAndInformation callSidecar(String jwt, String url, String eTag) throws CdsCommunicationException {
        HttpClient client = this.getHttpClient();
        logger.debug("Call sidecar on url {} ", (Object)url);
        HttpUriRequest request = RequestBuilder.get((String)url).setHeader("Authorization", "Bearer " + jwt).setHeader("Accept", APPLICATION_JSON).build();
        if (!Strings.isNullOrEmpty((String)eTag)) {
            request.setHeader("If-None-Match", eTag);
        }
        try (CloseableHttpResponse response = (CloseableHttpResponse)client.execute(request);){
            int httpStatusCode = response.getStatusLine().getStatusCode();
            switch (httpStatusCode) {
                case 304: {
                    logger.debug("Received not modified status");
                    ModelAndInformation modelAndInformation = new ModelAndInformation(null, eTag, true);
                    return modelAndInformation;
                }
                case 200: {
                    if (response.containsHeader("ETag")) {
                        eTag = response.getLastHeader("ETag").getValue();
                    }
                    String model = EntityUtils.toString((HttpEntity)response.getEntity());
                    logger.debug("Received the following model from sidecar: {}", (Object)model);
                    ModelAndInformation modelAndInformation = new ModelAndInformation(model, eTag, false);
                    return modelAndInformation;
                }
            }
            String contentAsString = EntityUtils.toString((HttpEntity)response.getEntity());
            String message = MessageFormat.format("Sidecar returned with status {0} and message {1}", httpStatusCode, contentAsString);
            logger.error(message);
            throw new CdsCommunicationException(message, httpStatusCode);
        }
        catch (IOException e) {
            throw new CdsCommunicationException("Communication error with sidecar.", (Throwable)e);
        }
    }

    private HttpDestination getSidecarDestination() throws CdsCommunicationException {
        HttpDestination sidecarHttpDestination = this.atomicSidecarHttpDestination.get();
        if (sidecarHttpDestination == null) {
            try {
                sidecarHttpDestination = DestinationAccessor.getDestination((String)MTX_SIDECAR_DESTINATION).asHttp();
            }
            catch (DestinationAccessException e) {
                try {
                    sidecarHttpDestination = DefaultHttpDestination.builder((String)this.sidecarBaseUrl).name(MTX_SIDECAR_DESTINATION).build();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CdsCommunicationException((Throwable)illegalArgumentException);
                }
            }
            if (!this.atomicSidecarHttpDestination.compareAndSet(null, sidecarHttpDestination)) {
                return this.atomicSidecarHttpDestination.get();
            }
        }
        return sidecarHttpDestination;
    }

    private HttpClient getHttpClient() throws CdsCommunicationException {
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)this.getSidecarDestination());
    }
}

