/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ClientCredentialJwtReader;
import java.util.Optional;

public class ClientCredentialJwtAccess
implements Authenticator {
    private static final String AUTHENTIFICATION_SCHEME = "Bearer";
    private final ClientCredentialJwtReader jwtReader;
    private volatile ClientCredentialJwtReader.Response response;

    public ClientCredentialJwtAccess(ClientCredentialJwtReader jwtReader) {
        this.jwtReader = jwtReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String getJwt() throws CdsCommunicationException {
        ClientCredentialJwtReader.Response localRef = this.response;
        if (localRef == null || !localRef.isValid()) {
            ClientCredentialJwtAccess clientCredentialJwtAccess = this;
            synchronized (clientCredentialJwtAccess) {
                localRef = this.response;
                if (localRef == null || !localRef.isValid()) {
                    this.response = localRef = this.jwtReader.getJwt();
                }
            }
        }
        return localRef.getAccessToken();
    }

    @Override
    public Optional<String> getAuthorization() {
        return Optional.of("Bearer " + this.getJwt());
    }
}

