/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sap.cds.CdsException;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAccessorImpl<M>
implements MetaDataAccessor<M> {
    private static final long NANOS_TO_SECONDS = 1000000000L;
    private static final Logger logger = LoggerFactory.getLogger(MetaDataAccessorImpl.class);
    private final SidecarAccess sidecarAccess;
    private final Cache<CdsModel> modelIdToCdsModel;
    private final Cache<M> modelIdToEdmxModel;
    private final EdmxModelCreator<M> strToEdmx;
    private final ExecutorService executorService;

    public MetaDataAccessorImpl(SidecarAccess sidecarAccess, CacheParams cacheParams, EdmxModelCreator<M> strToEdmx, Ticker cacheTicker) {
        this.strToEdmx = strToEdmx;
        this.sidecarAccess = sidecarAccess;
        if (cacheTicker == null) {
            cacheTicker = Ticker.systemTicker();
        }
        this.executorService = cacheParams.isSynchronousRefresh() ? MoreExecutors.newDirectExecutorService() : Executors.newSingleThreadExecutor();
        this.modelIdToCdsModel = new CdsCache(cacheParams, cacheTicker);
        this.modelIdToEdmxModel = new EdmxCache(cacheParams, cacheTicker);
    }

    public CdsModel getCdsModel(ModelId key, int maxAgeSeconds) {
        return this.modelIdToCdsModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    public M getEdmx(ModelId key, int maxAgeSeconds) throws CdsException {
        return this.modelIdToEdmxModel.getOrLoadIfStale(key, maxAgeSeconds);
    }

    public void evict(String tenantId) {
        this.modelIdToCdsModel.evict(tenantId);
        this.modelIdToEdmxModel.evict(tenantId);
    }

    public void refresh(String tenantId, int maxAgeSeconds) {
        this.modelIdToCdsModel.refresh(tenantId, maxAgeSeconds);
        this.modelIdToEdmxModel.refresh(tenantId, maxAgeSeconds);
    }

    private static <K, V> CacheLoader<K, V> getLoader(final BiFunction<K, V, V> loader, final ExecutorService executorService) {
        return new CacheLoader<K, V>(){

            public V load(K key) {
                return loader.apply(key, null);
            }

            public ListenableFuture<V> reload(K key, V oldValue) {
                ListenableFutureTask readModelTask = ListenableFutureTask.create(() -> {
                    try {
                        return loader.apply(key, oldValue);
                    }
                    catch (Exception e) {
                        logger.error("Error when model was reread: {}", (Throwable)e);
                        return oldValue;
                    }
                });
                executorService.execute((Runnable)readModelTask);
                return readModelTask;
            }
        };
    }

    private class CdsCache
    extends Cache<CdsModel> {
        public CdsCache(CacheParams params, Ticker ticker) {
            super(params, ticker);
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return MetaDataAccessorImpl.this.sidecarAccess.getCsn(key, eTag);
        }

        @Override
        CdsModel parse(ModelId key, String csn) {
            return CdsModelReader.read((String)csn, (boolean)true);
        }
    }

    private class EdmxCache
    extends Cache<M> {
        public EdmxCache(CacheParams params, Ticker ticker) {
            super(params, ticker);
        }

        @Override
        ModelAndInformation access(ModelId key, String eTag) {
            return MetaDataAccessorImpl.this.sidecarAccess.getEdmx(key, eTag);
        }

        @Override
        M parse(ModelId key, String model) {
            return MetaDataAccessorImpl.this.strToEdmx.parse(model, key.getServiceName().orElse(null));
        }
    }

    private abstract class Cache<V> {
        private final Ticker ticker;
        private final LoadingCache<ModelId, Entry> guavaCache;

        protected Cache(CacheParams params, Ticker ticker) {
            CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(params.getMaximumSize()).expireAfterAccess(params.getExpirationDuration(), params.getExpirationDurationUnit()).refreshAfterWrite(params.getRefreshDuration(), params.getRefreshDurationUnit());
            if (ticker != null) {
                builder.ticker(ticker);
            }
            this.guavaCache = builder.build(MetaDataAccessorImpl.getLoader(this::load, MetaDataAccessorImpl.this.executorService));
            this.ticker = ticker;
        }

        public void evict(String tenantId) {
            this.forTenant(tenantId, arg_0 -> this.guavaCache.invalidate(arg_0));
        }

        public void refresh(String tenantId, int maxAgeSeconds) {
            this.forTenant(tenantId, k -> this.getOrLoadIfStale((ModelId)k, maxAgeSeconds));
        }

        private void forTenant(String tenantId, Consumer<ModelId> action) {
            this.guavaCache.asMap().keySet().stream().filter(k -> k.getTenantId().equals(tenantId)).forEach(action);
        }

        public Entry getUnchecked(ModelId key) {
            return (Entry)this.guavaCache.getUnchecked((Object)key);
        }

        private void put(ModelId key, Entry entry) {
            this.guavaCache.put((Object)key, (Object)entry);
        }

        public V getOrLoadIfStale(ModelId key, int maxAgeSeconds) {
            Entry loaded;
            Entry entry;
            long maxAgeNanos = (long)maxAgeSeconds * 1000000000L;
            long now = this.ticker.read();
            try {
                entry = this.getUnchecked(key);
            }
            catch (UncheckedExecutionException e) {
                throw new CdsException((Throwable)e);
            }
            if (now - entry.refreshed() > maxAgeNanos && (loaded = this.load(key, entry)) != entry) {
                this.put(key, loaded);
                entry = loaded;
            }
            return entry.getEntry();
        }

        private Entry load(ModelId key, Entry oldEntry) {
            String eTag = oldEntry != null ? oldEntry.getETag() : null;
            ModelAndInformation model = this.access(key, eTag);
            if (oldEntry != null && model.isNotModified()) {
                oldEntry.refresh();
                return oldEntry;
            }
            return new Entry(this.parse(key, model.getModel()), model.getETag());
        }

        abstract ModelAndInformation access(ModelId var1, String var2);

        abstract V parse(ModelId var1, String var2);

        private class Entry {
            private final V entry;
            private final String eTag;
            private final AtomicLong refreshed;

            public Entry(V entry, String eTag) {
                this.refreshed = new AtomicLong(Cache.this.ticker.read());
                this.entry = entry;
                this.eTag = eTag.trim();
            }

            public V getEntry() {
                return this.entry;
            }

            public String getETag() {
                return this.eTag;
            }

            public void refresh() {
                this.refreshed.set(Cache.this.ticker.read());
            }

            public long refreshed() {
                return this.refreshed.get();
            }
        }
    }

    @FunctionalInterface
    public static interface EdmxModelCreator<M> {
        public M parse(String var1, String var2);
    }
}

