/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.AbstractSidecarAccess;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ModelAndInformation;
import com.sap.cds.mtx.impl.SidecarAccess;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class SidecarAccessV2
extends AbstractSidecarAccess
implements SidecarAccess {
    private static final String BASE_PATH = "/mtx/v2/model/";
    private static final String CSN_PATH = "/mtx/v2/model/csn/";
    private static final String EDMX_PATH = "/mtx/v2/model/edmx/";
    private static final String APPLICATION_JSON = "application/json";
    private static final ObjectMapper mapper = new ObjectMapper();

    public SidecarAccessV2(String sidecarBaseUrl, Authenticator authenticator) {
        super(sidecarBaseUrl, authenticator);
    }

    @Override
    public ModelAndInformation getCsn(ModelId id, String eTag) throws CdsCommunicationException {
        RequestBuilder builder = RequestBuilder.post((String)CSN_PATH).setHeader("Content-Type", APPLICATION_JSON).setEntity(SidecarAccessV2.entity(SidecarAccessV2.getCsnBody(id)));
        return this.callSidecar(builder.build(), eTag);
    }

    @Override
    public ModelAndInformation getEdmx(ModelId id, String eTag) throws CdsCommunicationException {
        RequestBuilder builder = RequestBuilder.post((String)EDMX_PATH).setHeader("Content-Type", APPLICATION_JSON).setEntity(SidecarAccessV2.entity(SidecarAccessV2.getEdmxBody(id)));
        return this.callSidecar(builder.build(), eTag);
    }

    private static Map<String, Object> getCsnBody(ModelId id) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenant", id.getTenantId());
        body.put("toggles", id.getFeatures());
        return body;
    }

    private static Map<String, Object> getEdmxBody(ModelId id) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenant", id.getTenantId());
        body.put("toggles", id.getFeatures());
        id.getServiceName().ifPresent(s -> body.put("service", s));
        id.getLanguage().ifPresent(l -> body.put("locale", l));
        return body;
    }

    private static HttpEntity entity(Map<String, Object> object) {
        try {
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            return new StringEntity(json);
        }
        catch (UnsupportedEncodingException e) {
            throw new CdsCommunicationException("unsupported encoding", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new CdsCommunicationException("malformed model id", (Throwable)e);
        }
    }
}

