/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsException;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.ConnectedDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.DeleteCascader;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.DeepInsertSplitter;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.PathExpressionResolver;
import com.sap.cds.util.ProjectionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsDataStoreImpl
implements CdsDataStore {
    private final CqnValidator cqnValidator;
    private final ConnectedClient connectedClient;
    private final CqnNormalizer cqnNormalizer;
    private final CqnAnalyzer cqnAnalyzer;
    private final DataUtils dataUtils;
    private final Context context;
    private final CdsModel model;
    private static final Logger logger = LoggerFactory.getLogger(CdsDataStoreImpl.class);
    private static final TimingLogger timed = new TimingLogger(logger);

    public CdsDataStoreImpl(Context context, ConnectedDataStoreConnector connector) {
        this.context = context;
        this.model = context.getCdsModel();
        this.cqnValidator = CqnValidator.create(context);
        this.connectedClient = connector.create(context);
        this.dataUtils = DataUtils.create(context::getSessionContext);
        this.connectedClient.setSessionContext(context.getSessionContext());
        this.cqnNormalizer = new CqnNormalizer(context);
        this.cqnAnalyzer = CqnAnalyzer.create((CdsModel)this.model);
    }

    public Result execute(CqnSelect select, Object ... paramValues) {
        return this.execute(select, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnSelect select, Map<String, Object> cqnParameterValues) {
        return (Result)timed.debug(() -> {
            CdsEntity rowType = null;
            if (select.from().isRef() && CqnStatementUtils.isSelectStar((List)select.items()) && select.excluding().isEmpty()) {
                rowType = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.from().asRef());
            }
            CqnSelect normSelect = this.cqnNormalizer.normalize(select);
            this.cqnValidator.validate(normSelect, this.connectedClient.capabilities());
            if (rowType == null) {
                rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)normSelect);
            }
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)normSelect);
            ResultBuilder result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, normSelect.getLock().isPresent()).rowType((CdsStructuredType)rowType);
            if (normSelect.hasInlineCount()) {
                long rowCount = result.rowCount();
                Optional limit = normSelect.limit();
                if (limit.isPresent() && CdsDataStoreImpl.requiresInlineCountQuery((CqnLimit)limit.get(), rowCount)) {
                    result.inlineCount(this.getInlineCount(normSelect, cqnParameterValues));
                } else {
                    result.inlineCount(rowCount);
                }
            }
            return result.result();
        }, "CQN >>{}<<", () -> new Object[]{this.safeToJson(select)});
    }

    private long getInlineCount(CqnSelect select, Map<String, Object> cqnParameterValues) {
        CqnSelect inlineCountQuery = CqnStatementUtils.inlineCountQuery((CqnSelect)select);
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)inlineCountQuery);
        Result result = this.connectedClient.executeQuery(pcqn, cqnParameterValues, this, false).result();
        return ((CqnStatementUtils.Count)result.single(CqnStatementUtils.Count.class)).getCount();
    }

    private String safeToJson(CqnSelect select) {
        try {
            return select.toJson();
        }
        catch (RuntimeException ex) {
            logger.error("cannot serialize CQN statement");
            return "Unserializable CQN";
        }
    }

    @VisibleForTesting
    static boolean requiresInlineCountQuery(CqnLimit l, long rowCount) {
        return l.skip() > 0L || l.top() <= rowCount;
    }

    public Result execute(CqnDelete delete, Object ... paramValues) {
        return this.execute(delete, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnDelete delete, Map<String, Object> namedValues) {
        return this.execute(delete, Collections.singletonList(namedValues));
    }

    public Result execute(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        delete = this.resolveProjection(delete);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)delete.ref());
        delete = (CqnDelete)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, (CqnStatement)delete);
        try {
            DeleteCascader.create(target).from(delete.ref()).where(delete.where()).cascade(d -> this.bulkDelete((CqnDelete)d, (Iterable<? extends Map<String, Object>>)valueSets, true));
            return this.bulkDelete(delete, valueSets, false);
        }
        catch (UnsupportedOperationException e) {
            CqnDelete normDelete = this.cqnNormalizer.normalize(delete);
            target = this.model.getEntity(normDelete.ref().firstSegment());
            Set<EntityCascader.EntityKeys> entities = this.cascade(target, normDelete.where(), valueSets);
            Result result = this.bulkDelete(delete, valueSets, false);
            this.delete(entities.stream().map(EntityCascader.EntityOperation::delete), true);
            return result;
        }
    }

    private Set<EntityCascader.EntityKeys> cascade(CdsEntity target, Optional<CqnPredicate> filter, Iterable<? extends Map<String, Object>> valueSets) {
        EntityCascader cascader = EntityCascader.from(this, target).where(filter);
        Set<EntityCascader.EntityKeys> keySets = valueSets.iterator().hasNext() ? Streams.stream(valueSets).flatMap(v -> cascader.with((Map<String, Object>)v).cascade(EntityCascader.CascadeType.DELETE).stream()).collect(Collectors.toSet()) : cascader.cascade(EntityCascader.CascadeType.DELETE);
        return keySets;
    }

    private void upsert(Stream<EntityCascader.EntityOperation> operations) {
        List<EntityCascader.EntityOperation> notInDatastore = this.update(operations);
        this.insert(notInDatastore.stream());
    }

    private void insert(Stream<EntityCascader.EntityOperation> ops) {
        ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity)).forEach((entity, data) -> {
            Iterator rows = this.execute((CqnInsert)Insert.into((CdsEntity)entity).entries((Iterable)data)).iterator();
            for (EntityCascader.EntityOperation op : data) {
                op.inserted((Map)rows.next());
            }
        });
    }

    private List<EntityCascader.EntityOperation> update(Stream<EntityCascader.EntityOperation> ops) {
        ArrayList<EntityCascader.EntityOperation> notFound = new ArrayList<EntityCascader.EntityOperation>();
        ops.collect(Collectors.groupingBy(o -> Objects.hash(o.targetEntity().getQualifiedName(), o.updateValues().keySet()))).forEach((g, updates) -> {
            CdsEntity entity = ((EntityCascader.EntityOperation)((Object)((Object)updates.get(0)))).targetEntity();
            List entries = updates.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpdate)Update.entity((CdsEntity)entity).entries(entries));
            if (result.rowCount() > 0L) {
                Iterator resultIter = result.iterator();
                Iterator updateIter = updates.iterator();
                for (int i = 0; i < result.batchCount(); ++i) {
                    EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)updateIter.next()));
                    u.updated((Map)resultIter.next());
                    if (result.rowCount(i) != 0L) continue;
                    notFound.add(u);
                }
            } else {
                notFound.addAll((Collection<EntityCascader.EntityOperation>)updates);
            }
        });
        return notFound;
    }

    private void delete(Stream<EntityCascader.EntityOperation> ops, boolean rollbackOnFail) {
        Map<CdsEntity, List<EntityCascader.EntityOperation>> keyMap = ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity));
        keyMap.forEach((entity, op) -> {
            if (!op.isEmpty()) {
                Set keyNames = ((EntityCascader.EntityOperation)((Object)((Object)op.iterator().next()))).targetKeys().keySet();
                DeleteBuilder delete = DeleteBuilder.from((String)entity.getQualifiedName()).matching(CqnParam.params((Collection)keyNames));
                this.bulkDelete((CqnDelete)delete, (Iterable<? extends Map<String, Object>>)op, rollbackOnFail);
                op.forEach(EntityCascader.EntityOperation::deleted);
            }
        });
    }

    private Result bulkDelete(CqnDelete delete, Iterable<? extends Map<String, Object>> valueSets, boolean rollbackOnFail) {
        this.cqnValidator.validate(delete);
        delete = PathExpressionResolver.resolvePath((CdsModel)this.model, (CqnDelete)delete);
        delete = this.resolveProjection(delete);
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)delete);
        ArrayList<Map<String, Object>> parameterValues = new ArrayList<Map<String, Object>>();
        valueSets.forEach(parameterValues::add);
        try {
            int[] deleteCount = this.connectedClient.executeUpdate(pcqn, parameterValues);
            return ResultBuilder.deletedRows((int[])deleteCount).result();
        }
        catch (Exception e) {
            if (rollbackOnFail) {
                this.connectedClient.setRollbackOnly();
            }
            throw e;
        }
    }

    public Result execute(CqnInsert insert) {
        insert = this.isDraftEnabled(insert);
        insert = this.cqnNormalizer.normalize(insert);
        return this.deepInsert((CqnXsert)insert, false);
    }

    private CqnInsert isDraftEnabled(CqnInsert insert) {
        CdsEntity entity = this.model.getEntity(insert.ref().firstSegment());
        if (entity.findAnnotation("odata.draft.enabled").isPresent()) {
            insert = this.resolveProjection(insert);
        }
        return insert;
    }

    public Result execute(CqnUpsert upsert) {
        if (upsert.entries().isEmpty()) {
            return ResultBuilder.insertedRows(Collections.emptyList()).result();
        }
        upsert = this.cqnNormalizer.normalize(upsert);
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)upsert.ref());
        this.deleteByKeys(entity, upsert.entries());
        return this.deepInsert((CqnXsert)upsert, true);
    }

    private Result deleteByKeys(CdsEntity entity, Iterable<Map<String, Object>> keyValues) {
        Delete delete = Delete.from((CdsEntity)entity).matching(CdsModelUtils.keyNames((CdsStructuredType)entity).stream().collect(Collectors.toMap(k -> k, k -> CQL.param((String)k))));
        DataUtils.normalizedUuidKeys((CdsStructuredType)entity, keyValues);
        return this.execute((CqnDelete)delete, keyValues);
    }

    private Result deepInsert(CqnXsert xsert, boolean rollbackOnFail) {
        CdsEntity entity = this.model.getEntity(xsert.ref().firstSegment());
        List entries = xsert.entries();
        this.dataUtils.prepareForInsert(entity, entries);
        List<Insert> inserts = new DeepInsertSplitter(this.model, entity.getQualifiedName()).split(entries);
        boolean isRollbackOnly = rollbackOnFail || inserts.size() > 1;
        inserts.forEach(insert -> {
            this.cqnValidator.validate((CqnInsert)insert);
            insert = this.resolveProjection(insert);
            CdsEntity target = this.model.getEntity(insert.ref().firstSegment());
            DataUtils.resolvePaths((CdsEntity)target, (List)insert.entries());
            if (DataUtils.isDeep((CdsEntity)target, (Map)((Map)insert.entries().get(0)))) {
                this.deepInsert((CqnXsert)insert, true);
                return;
            }
            this.dataUtils.removeVirtualElements((CdsStructuredType)target, insert.entries());
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)insert);
            try {
                this.connectedClient.executeUpdate(pcqn, insert.entries());
            }
            catch (Exception e) {
                if (isRollbackOnly) {
                    this.connectedClient.setRollbackOnly();
                }
                throw e;
            }
        });
        return ResultBuilder.insertedRows((List)entries).result();
    }

    public Result execute(CqnUpdate update, Object ... paramValues) {
        return this.execute(update, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnUpdate update, Map<String, Object> namedValues) {
        return this.execute(update, namedValues.isEmpty() ? Collections.emptyList() : Collections.singletonList(namedValues));
    }

    public Result execute(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        this.cqnValidator.validate(update);
        CdsEntity entity = this.cqnAnalyzer.analyze(update.ref()).targetEntity();
        this.dataUtils.prepareForUpdate(entity, update.entries());
        CqnUpdate normUpdate = this.cqnNormalizer.normalize(update);
        if (DataUtils.isDeep((CdsEntity)entity, (Map)update.data())) {
            return this.deepUpdate(entity, normUpdate);
        }
        CqnUpdate resolvedUpdate = this.resolveProjection(normUpdate);
        if (resolvedUpdate != normUpdate) {
            entity = this.cqnAnalyzer.analyze(resolvedUpdate.ref()).targetEntity();
            DataUtils.resolvePaths((CdsEntity)entity, (List)resolvedUpdate.entries());
            if (DataUtils.isDeep((CdsEntity)entity, (Map)resolvedUpdate.data())) {
                return this.deepUpdate(entity, resolvedUpdate);
            }
        }
        List<Map<String, Object>> parameterValues = CdsDataStoreImpl.mergeParams(resolvedUpdate.entries(), valueSets);
        CqnStatementUtils.moveKeyValuesToWhere((CdsStructuredType)entity, (CqnUpdate)resolvedUpdate, (boolean)true);
        if (resolvedUpdate.data().isEmpty()) {
            entity = this.cqnAnalyzer.analyze(update.ref()).targetEntity();
            CqnStatementUtils.moveKeyValuesToWhere((CdsStructuredType)entity, (CqnUpdate)update, (boolean)false);
            long count = ((CqnStatementUtils.Count)this.execute(CqnStatementUtils.countAllQuery((CqnUpdate)update), new Object[0]).single().as(CqnStatementUtils.Count.class)).getCount();
            return ResultBuilder.updatedRows((long)count, new HashMap()).result();
        }
        this.dataUtils.removeVirtualElements((CdsStructuredType)entity, resolvedUpdate.entries());
        PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)resolvedUpdate);
        int[] updateCount = this.connectedClient.executeUpdate(pcqn, parameterValues);
        return ResultBuilder.updatedRows((int[])updateCount, (List)update.entries()).result();
    }

    private Result deepUpdate(CdsEntity entity, CqnUpdate update) {
        if (update.entries().size() > 1) {
            throw new UnsupportedOperationException("Deep bulk updates are not supported");
        }
        EntityCascader cascader = EntityCascader.from(this, entity);
        EntityCascader.EntityOperations operations = cascader.cascadeUpdate(update);
        try {
            this.delete(operations.stream(EntityCascader.EntityOperation.Operation.DELETE), false);
            this.insert(operations.stream(EntityCascader.EntityOperation.Operation.INSERT));
            this.upsert(operations.stream(EntityCascader.EntityOperation.Operation.UPSERT));
            this.update(operations.stream(EntityCascader.EntityOperation.Operation.UPDATE));
        }
        catch (Exception e) {
            this.connectedClient.setRollbackOnly();
            throw e;
        }
        boolean changed = operations.executed().anyMatch(o -> true);
        return ResultBuilder.updatedRows((int)(changed ? 1 : 0), operations.data()).result();
    }

    private <T extends CqnStatement> T resolveProjection(T cqn) {
        ProjectionResolver.BiValueFunction isTable = (prev, stmnt) -> (Boolean)this.cqnAnalyzer.analyze(stmnt.ref()).targetEntity().getAnnotationValue("cds.persistence.table", (Object)false);
        return (T)ProjectionResolver.create((CdsModel)this.model, cqn).condition(isTable).resolveAll().getResolvedStatement();
    }

    private static List<Map<String, Object>> mergeParams(List<Map<String, Object>> updateData, Iterable<Map<String, Object>> valueSets) {
        ArrayList<Map<String, Object>> paramVals = new ArrayList<Map<String, Object>>();
        if (!valueSets.iterator().hasNext()) {
            updateData.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
            return paramVals;
        }
        valueSets.forEach(v -> paramVals.add(DataUtils.copyMap((Map)v)));
        if (updateData.size() == 1) {
            Map<String, Object> data = updateData.get(0);
            paramVals.forEach(p -> p.putAll(data));
            return paramVals;
        }
        if (updateData.size() == paramVals.size()) {
            Iterator<Map<String, Object>> keyIter = updateData.iterator();
            paramVals.forEach(p -> p.putAll((Map)keyIter.next()));
            return paramVals;
        }
        throw new CdsException("Batch update failed: Parameter value list size (" + paramVals.size() + ") does not match batch size (" + updateData.size() + ")");
    }

    private static Map<String, Object> toIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    public SessionContext getSessionContext() {
        return this.context.getSessionContext();
    }

    public void setSessionContext(SessionContext session) {
        this.context.setSessionContext(session);
        this.connectedClient.setSessionContext(session);
    }
}

