/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.CqnAnalyzerImpl;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityCascader {
    private final CdsDataStore dataStore;
    private final CdsEntity rootEntity;
    private final Map<String, Object> paramValues = new HashMap<String, Object>();
    private final Set<EntityKeys> visited = new HashSet<EntityKeys>();
    private final EntityOperations operations = new EntityOperations();
    private CqnPredicate rootFilter;
    boolean dataDriven = false;

    private EntityCascader(CdsDataStore dataStore, CdsEntity rootEntity) {
        this.dataStore = dataStore;
        this.rootEntity = rootEntity;
    }

    public static EntityCascader from(CdsDataStore dataStore, CdsEntity entity) {
        return new EntityCascader(dataStore, entity);
    }

    public EntityCascader where(Optional<CqnPredicate> pred) {
        return this.where((CqnPredicate)pred.orElse(null));
    }

    public EntityCascader where(CqnPredicate pred) {
        this.rootFilter = pred;
        return this;
    }

    public EntityCascader with(Map<String, Object> paramValues) {
        this.paramValues.clear();
        this.paramValues.putAll(paramValues);
        return this;
    }

    public Set<EntityKeys> cascade(CascadeType cascadeType) {
        this.cascadeRoot((d, a) -> EntityCascader.isCascading(cascadeType, a), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    @VisibleForTesting
    public Set<EntityKeys> cascade(Predicate<CdsAssociationType> assocFilter) {
        this.cascadeRoot((d, a) -> assocFilter.test((CdsAssociationType)a.getType()), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    public EntityOperations cascadeUpdate(CqnUpdate update) {
        this.dataDriven = true;
        this.operations.data(update.data());
        CqnPredicate filter = CqnStatementUtils.extractTargetFilter((CdsStructuredType)this.rootEntity, (CqnUpdate)update, (boolean)false);
        StructuredType path = CQL.entity((String)this.rootEntity.getQualifiedName()).filter(filter);
        Result result = this.dataStore.execute((CqnSelect)Select.from((StructuredType)path), new Object[0]);
        if (result.first().isPresent()) {
            if (result.rowCount() > 1L) {
                throw new CdsDataException("Searched deep updates are not supported. Key values for entity " + this.rootEntity + " are missing.");
            }
            Row currentData = result.single();
            EntityKeys entityKeys = EntityKeys.keys(this.rootEntity, (Map<String, Object>)currentData);
            this.operations.add(EntityOperation.nop(entityKeys, (Map<String, Object>)currentData).update(this.operations.data()));
            this.cascade(this.rootEntity, filter, this.paramValues, EntityCascader.associationsInData(), this.operations.data());
        }
        return this.operations;
    }

    public static Stream<EntityOperation> cascadeDelete(CdsDataStore dataStore, EntityKeys targetEntity) {
        return EntityCascader.from(dataStore, targetEntity.entity).where((CqnPredicate)ExpressionImpl.matching((Map)((Object)targetEntity))).cascade(CascadeType.DELETE).stream().map(EntityOperation::delete);
    }

    private static BiPredicate<Map<String, Object>, CdsElement> associationsInData() {
        return (d, a) -> d != null && d.keySet().contains(a.getName());
    }

    private static Map<String, Object> computeFkValues(CdsElement association, Map<String, Object> targetValues) {
        return new OnConditionAnalyzer(association, CdsModelUtils.isReverseAssociation((CdsElement)association)).getFkValues(targetValues);
    }

    private void cascadeRoot(BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        this.cascade(this.rootEntity, this.rootFilter, this.paramValues, assocFilter, data);
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        entity.associations().filter(a -> assocFilter.test(data, (CdsElement)a)).forEach(assoc -> this.cascade(entity, filter, paramValues, assocFilter, (CdsElement)assoc, data));
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, CdsElement association, Map<String, Object> data) {
        String assocName = association.getName();
        CdsAssociationType assocType = (CdsAssociationType)association.getType();
        StructuredType path = CQL.entity((String)entity.getQualifiedName()).filter(filter).to(assocName);
        CdsEntity targetEntity = assocType.getTarget();
        if (CdsModelUtils.isSingleValued((CdsType)assocType)) {
            this.cascadeToOne(path, entity, targetEntity, association, paramValues, assocFilter, data);
        } else {
            List<Map<String, Object>> d = EntityCascader.getList(data, assocName);
            this.cascadeToMany(path, targetEntity, association, paramValues, assocFilter, d);
        }
    }

    private static Map<String, Object> getMap(Map<String, Object> data, String key) {
        return data.getOrDefault(key, Collections.emptyMap());
    }

    private static List<Map<String, Object>> getList(Map<String, Object> data, String key) {
        return (List)data.get(key);
    }

    private void cascadeToOne(StructuredType<?> path, CdsEntity parent, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> parentData) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        Result targetData = this.dataStore.execute(selectTargetKeys, paramValues);
        ArrayList<EntityKeys> targetKeys = new ArrayList<EntityKeys>();
        Map<String, Object> newData = EntityCascader.getMap(parentData, association.getName());
        if (this.dataDriven) {
            if (newData == null) {
                this.scheduleRemovals(targetData.stream().map(d -> EntityKeys.keys(target, (Map<String, Object>)d)), association);
            } else if (EntityCascader.isNewTargetData(targetData, newData)) {
                boolean keyGenerated = EntityCascader.generateUuidKeys(target, newData);
                EntityOperation operation = EntityCascader.xsert(association, EntityKeys.keys(target, newData), newData);
                if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                    Map<String, Object> keys2 = EntityCascader.parentKeys(path, association);
                    operation.update(EntityCascader.computeFkValues(association, keys2));
                } else if (keyGenerated) {
                    Map<String, Object> keys3 = EntityCascader.parentKeys(path, association);
                    Map<String, Object> fks = EntityCascader.computeFkValues(association, (Map<String, Object>)((Object)operation.targetKeys()));
                    this.operations.add(EntityCascader.update(parent, keys3, fks));
                    parentData.putAll(fks);
                }
                this.operations.add(operation);
                targetKeys.add(operation.targetKeys());
            } else {
                targetData.stream().map(oldData -> EntityCascader.update(target, (Map<String, Object>)oldData, newData)).forEach(op -> {
                    EntityCascader.assertCascading(op, association);
                    this.operations.add((EntityOperation)((Object)op));
                    targetKeys.add(op.targetKeys());
                });
            }
        } else {
            targetData.stream().map(data -> EntityKeys.keys(target, (Map<String, Object>)data)).forEach(targetKeys::add);
        }
        targetKeys.stream().filter(this::notVisited).forEach(keys -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)keys)), Collections.emptyMap(), assocFilter, newData));
    }

    private static boolean generateUuidKeys(CdsEntity target, Map<String, Object> newData) {
        int s = newData.size();
        DataUtils.generateUuidKeys((CdsStructuredType)target, newData);
        return newData.size() > s;
    }

    private static Map<String, Object> parentKeys(StructuredType<?> path, CdsElement association) {
        StructuredTypeRef ref = StructuredTypeRefImpl.typeRef(path);
        CqnReference.Segment parentSeg = (CqnReference.Segment)ref.segments().get(ref.segments().size() - 2);
        return CqnAnalyzerImpl.extractKeys((CqnReference.Segment)parentSeg, (CdsEntity)((CdsEntity)association.getDeclaringType()));
    }

    private static EntityOperation update(CdsEntity target, Map<String, Object> data, Map<String, Object> newData) {
        return EntityOperation.nop(EntityKeys.keys(target, data), data).update(newData);
    }

    private void cascadeToMany(StructuredType<?> path, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, List<Map<String, Object>> newData) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        Set<EntityKeys> targetKeys = this.dataStore.execute(selectTargetKeys, paramValues).stream().map(row -> EntityKeys.keys(target, (Map<String, Object>)row)).collect(Collectors.toSet());
        if (this.dataDriven) {
            if (newData == null) {
                throw new CdsDataException("Value for to-many association '" + association.getDeclaringType() + "." + association + "' must not be null.");
            }
            Map<String, Object> fks = EntityCascader.computeFkValues(association, EntityCascader.parentKeys(path, association));
            Map<EntityKeys, Map<String, Object>> newTargetData = this.scheduleUpserts(association, target, targetKeys, newData, fks);
            Set removed = Sets.filter(targetKeys, key -> !newTargetData.keySet().contains(key));
            this.scheduleRemovals(removed.stream(), association);
            newTargetData.forEach((targetKey, data) -> {
                if (this.notVisited((EntityKeys)((Object)targetKey))) {
                    this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)targetKey)), Collections.emptyMap(), assocFilter, (Map<String, Object>)data);
                }
            });
        } else {
            targetKeys.stream().filter(this::notVisited).forEach(k -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)k)), Collections.emptyMap(), assocFilter, Collections.emptyMap()));
        }
    }

    private Map<EntityKeys, Map<String, Object>> scheduleUpserts(CdsElement association, CdsEntity target, Set<EntityKeys> targetKeys, List<Map<String, Object>> newData, Map<String, Object> fks) {
        HashMap<EntityKeys, Map<String, Object>> newTargetData = new HashMap<EntityKeys, Map<String, Object>>();
        newData.stream().forEach(data -> {
            data.putAll(fks);
            boolean keyGenerated = EntityCascader.generateUuidKeys(target, data);
            EntityKeys targetEntity = EntityKeys.keys(target, data);
            newTargetData.put(targetEntity, (Map<String, Object>)data);
            this.scheduleXsert(association, targetEntity, targetKeys, (Map<String, Object>)data, fks.keySet(), keyGenerated);
        });
        return newTargetData;
    }

    private void scheduleXsert(CdsElement association, EntityKeys targetEntity, Set<EntityKeys> targetKeys, Map<String, Object> updateData, Set<String> fks, boolean insert) {
        EntityOperation operation;
        if (targetKeys.contains((Object)targetEntity)) {
            fks.forEach(updateData::remove);
            operation = EntityOperation.nop(targetEntity).update(updateData);
        } else {
            operation = insert ? EntityCascader.insert(association, targetEntity, updateData) : EntityCascader.xsert(association, targetEntity, updateData);
        }
        EntityCascader.assertCascading(operation, association);
        this.operations.add(operation);
    }

    private static EntityOperation insert(CdsElement association, EntityKeys targetEntity, Map<String, Object> data) {
        if (EntityCascader.isCascading(CascadeType.INSERT, association)) {
            return EntityOperation.insert(targetEntity, data);
        }
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        throw new CdsDataException(String.format("INSERT into entity '%s' via association '%s.%s' is not allowed. The association does not cascade insert.", target, association.getDeclaringType(), association));
    }

    private static EntityOperation xsert(CdsElement association, EntityKeys targetEntity, Map<String, Object> entityData) {
        boolean insert = EntityCascader.isCascading(CascadeType.INSERT, association);
        boolean update = EntityCascader.isCascading(CascadeType.UPDATE, association);
        if (insert && update) {
            return EntityOperation.upsert(targetEntity, entityData);
        }
        if (insert) {
            return EntityOperation.insert(targetEntity, entityData);
        }
        if (update) {
            return EntityOperation.nop(targetEntity).update(entityData);
        }
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        throw new CdsDataException(String.format("UPSERT entity '%s' via association '%s.%s' is not allowed. The association does not cascade insert or update.", target, association.getDeclaringType(), association));
    }

    private void scheduleRemovals(Stream<EntityKeys> keys, CdsElement association) {
        if (EntityCascader.isCascading(CascadeType.DELETE, association)) {
            keys.forEach(k -> {
                this.operations.add(EntityOperation.delete(k));
                EntityCascader.cascadeDelete(this.dataStore, k).forEach(this.operations::add);
            });
        } else if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
            EntityCascader.assertCascading(CascadeType.UPDATE, association);
            Set<String> fkNames = EntityCascader.computeFkValues(association, Collections.emptyMap()).keySet();
            keys.map(k -> EntityOperation.nop(k).updateToNull(fkNames)).forEach(this.operations::add);
        }
    }

    private Select<?> selectTargetKeys(CdsElement association, StructuredType<?> path) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        return SelectBuilder.from(path).columns(assoc.getTarget().keyElements().flatMap(x$0 -> EntityCascader.slis(x$0, new String[0])));
    }

    private static Stream<CqnSelectListItem> slis(CdsElement keyElement, String ... association) {
        String[] path = Arrays.copyOf(association, association.length + 1);
        path[path.length - 1] = keyElement.getName();
        if (keyElement.getType().isAssociation()) {
            return ((CdsAssociationType)keyElement.getType().as(CdsAssociationType.class)).keys().flatMap(k -> EntityCascader.slis(k, path));
        }
        return Stream.of(EntityCascader.sli(path));
    }

    private static CqnSelectListItem sli(String ... path) {
        ElementRef element = ElementRefImpl.element((String[])path);
        SelectListValueBuilder sli = SelectListValueBuilder.select((CqnValue)element);
        if (path.length > 1) {
            String alias = Arrays.stream(path).collect(Collectors.joining("."));
            return sli.as(alias).build();
        }
        return sli.build();
    }

    private static boolean isNewTargetData(Result result, Map<String, Object> data) {
        return !result.first().isPresent() && !data.isEmpty();
    }

    private boolean notVisited(EntityKeys keys) {
        return this.visited.add(keys);
    }

    private static void assertCascading(EntityOperation op, CdsElement association) {
        if (op.operation == EntityOperation.Operation.UPDATE) {
            EntityCascader.assertCascading(CascadeType.UPDATE, association);
        } else if (op.operation == EntityOperation.Operation.INSERT) {
            EntityCascader.assertCascading(CascadeType.INSERT, association);
        } else if (op.operation == EntityOperation.Operation.UPSERT) {
            EntityCascader.assertCascading(CascadeType.UPDATE, association);
            EntityCascader.assertCascading(CascadeType.INSERT, association);
        } else if (op.operation == EntityOperation.Operation.DELETE) {
            EntityCascader.assertCascading(CascadeType.DELETE, association);
        }
    }

    private static void assertCascading(CascadeType cascadeType, CdsElement association) {
        if (!EntityCascader.isCascading(cascadeType, association)) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            throw new CdsDataException(String.format("%s entity '%s' via association '%s.%s' is not allowed. The association does not cascade %s.", new Object[]{cascadeType.name(), target, association.getDeclaringType(), association, cascadeType}));
        }
    }

    public static boolean isCascading(CascadeType cascadeType, CdsElement association) {
        CdsType type = association.getType();
        if (type.isAssociation()) {
            Optional cascade = association.findAnnotation("cascade." + (Object)((Object)cascadeType));
            if (!cascade.isPresent()) {
                cascade = association.findAnnotation("cascade.all");
            }
            return cascade.map(CdsAnnotation::getValue).orElseGet(() -> ((CdsAssociationType)type.as(CdsAssociationType.class)).isComposition());
        }
        return false;
    }

    public static class EntityKeys
    extends ForwardingMap<String, Object> {
        private final CdsEntity entity;
        private final Map<String, Object> keys;

        private EntityKeys(CdsEntity entity, Map<String, Object> keys) {
            this.entity = entity;
            this.keys = keys;
        }

        public static EntityKeys keys(CdsEntity entity, Map<String, Object> data) {
            HashMap<String, Object> keyValues = new HashMap<String, Object>();
            Set keyNames = CdsModelUtils.keyNames((CdsStructuredType)entity);
            keyNames.remove("IsActiveEntity");
            keyNames.stream().forEach(k -> keyValues.put((String)k, null));
            keyValues.putAll(Maps.filterKeys(data, keyNames::contains));
            keyValues.forEach((k, v) -> EntityKeys.assertNotNull(entity.getElement(k), v));
            return new EntityKeys(entity, keyValues);
        }

        private static void assertNotNull(CdsElement element, Object value) {
            if (value == null) {
                throw new CdsDataException("Value of key element '" + element + "' of entity " + element.getDeclaringType() + " must not be null");
            }
        }

        public Map<String, Object> keys() {
            return Collections.unmodifiableMap(this.keys);
        }

        public CdsEntity entity() {
            return this.entity;
        }

        protected Map<String, Object> delegate() {
            return this.keys;
        }

        public int hashCode() {
            return Objects.hash(this.entity.getQualifiedName(), this.keys);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityKeys other = (EntityKeys)((Object)obj);
            if (!this.entity.getQualifiedName().equals(other.entity.getQualifiedName())) {
                return false;
            }
            return this.keys.equals(other.keys);
        }

        public String toString() {
            return this.entity.getQualifiedName() + "[" + this.keys.toString() + "]";
        }
    }

    public static class EntityOperation
    extends ForwardingMap<String, Object> {
        private final EntityKeys targetKeys;
        private final Map<String, Object> data = new HashMap<String, Object>();
        private final Set<String> updated = new HashSet<String>();
        private Map<String, Object> updateData;
        private State state = State.UNCHANGED;
        private Operation operation;

        private EntityOperation(EntityKeys targetKeys, Operation operation) {
            this.targetKeys = targetKeys;
            this.data.putAll((Map<String, Object>)((Object)targetKeys));
            this.operation = operation;
        }

        public static EntityOperation nop(EntityKeys entity) {
            return new EntityOperation(entity, Operation.NOP);
        }

        public static EntityOperation nop(EntityKeys entity, Map<String, Object> data) {
            return EntityOperation.nop(entity).data(data);
        }

        public static EntityOperation upsert(EntityKeys entity, Map<String, Object> data) {
            return new EntityOperation(entity, Operation.UPSERT).update(data);
        }

        public static EntityOperation insert(EntityKeys entity, Map<String, Object> data) {
            return new EntityOperation(entity, Operation.INSERT).data(data);
        }

        public static EntityOperation delete(EntityKeys targetKeys) {
            return new EntityOperation(targetKeys, Operation.DELETE);
        }

        public CdsEntity targetEntity() {
            return this.targetKeys.entity;
        }

        public Operation operation() {
            return this.operation;
        }

        public State state() {
            return this.state;
        }

        private EntityOperation data(Map<String, Object> data) {
            this.updateData = data;
            this.data.putAll(EntityOperation.flattenData(this.targetKeys.entity, data));
            return this;
        }

        public boolean inserted(Map<String, Object> data) {
            if (!data.isEmpty()) {
                this.mergeData(data);
                this.state = State.INSERTED;
                return true;
            }
            return false;
        }

        public boolean updated(Map<String, Object> data) {
            if (!data.isEmpty()) {
                this.mergeData(data);
                this.state = State.UPDATED;
                return true;
            }
            return false;
        }

        public EntityOperation deleted() {
            this.state = State.DELETED;
            return this;
        }

        private EntityOperation updateToNull(Set<String> keys) {
            for (String key : keys) {
                this.data.put(key, null);
                this.updated.add(key);
                this.operation = Operation.UPDATE;
            }
            return this;
        }

        private EntityOperation update(Map<String, Object> updateData) {
            this.mergeData(updateData);
            if (!updateData.isEmpty()) {
                Map<String, Object> flattenedData = EntityOperation.flattenData(this.targetEntity(), updateData);
                flattenedData.forEach((key, newValue) -> {
                    boolean valuePresent = this.data.containsKey(key);
                    Object oldVal = this.data.put((String)key, newValue);
                    if (!valuePresent || !Objects.equals(oldVal, newValue)) {
                        Object keyVal;
                        this.updated.add((String)key);
                        if (this.operation == Operation.NOP) {
                            this.operation = Operation.UPDATE;
                        }
                        if ((keyVal = this.targetKeys.get(key)) != null && !keyVal.equals(newValue)) {
                            throw new CdsDataException("Key values cannot be changed");
                        }
                    }
                });
            }
            return this;
        }

        private void mergeData(Map<String, Object> data) {
            if (this.updateData == null) {
                this.updateData = data;
            } else {
                this.updateData.putAll(data);
            }
        }

        private static Map<String, Object> flattenData(CdsEntity entity, Map<String, Object> updateData) {
            HashMap<String, Object> copy = new HashMap<String, Object>(updateData);
            EntityOperation.associationsInData(entity, updateData).forEach(a -> EntityOperation.flattenData(a, (Map<String, Object>)copy));
            return copy;
        }

        private static Stream<CdsElement> associationsInData(CdsEntity e, Map<String, Object> d) {
            return e.associations().filter(a -> d.keySet().contains(a.getName()));
        }

        private static void flattenData(CdsElement association, Map<String, Object> data) {
            if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                data.remove(association.getName());
            } else {
                Map targetValues = (Map)data.remove(association.getName());
                if (targetValues == null) {
                    data.putAll(EntityOperation.computeFkValues(association, Collections.emptyMap()));
                } else if (targetValues.keySet().containsAll(CdsModelUtils.targetKeys((CdsElement)association))) {
                    data.putAll(EntityOperation.computeFkValues(association, targetValues));
                }
            }
        }

        private static Map<String, Object> computeFkValues(CdsElement association, Map<String, Object> targetValues) {
            return new OnConditionAnalyzer(association, CdsModelUtils.isReverseAssociation((CdsElement)association)).getFkValues(targetValues);
        }

        public EntityKeys targetKeys() {
            return this.targetKeys;
        }

        public Map<String, Object> data() {
            return Collections.unmodifiableMap(this.data);
        }

        public Map<String, Object> updateValues() {
            HashMap<String, Object> values = new HashMap<String, Object>(Maps.filterKeys(this.data, this.updated::contains));
            values.putAll((Map<String, Object>)((Object)this.targetKeys));
            return values;
        }

        public boolean hasNonKeyValues() {
            return !Sets.filter(this.data.keySet(), k -> !this.targetKeys.containsKey(k)).isEmpty();
        }

        protected Map<String, Object> delegate() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetKeys, this.data});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityOperation other = (EntityOperation)((Object)obj);
            if (!this.targetKeys.equals((Object)other.targetKeys)) {
                return false;
            }
            return this.data.equals(other.data);
        }

        public String toString() {
            return (Object)((Object)this.operation) + " " + (Object)((Object)this.targetKeys) + ": " + this.data.toString();
        }

        public static enum State {
            UNCHANGED,
            INSERTED,
            UPDATED,
            DELETED;

        }

        public static enum Operation {
            NOP,
            INSERT,
            UPDATE,
            UPSERT,
            DELETE;

        }
    }

    public static class EntityOperations {
        private final Set<EntityOperation> operations = new HashSet<EntityOperation>();
        private final Map<String, Object> data = new HashMap<String, Object>();

        public void data(Map<String, Object> data) {
            this.data.putAll(data);
        }

        public Map<String, Object> data() {
            return this.data;
        }

        public boolean add(EntityOperation op) {
            return this.operations.add(op);
        }

        public Stream<EntityOperation> stream(EntityOperation.Operation operation) {
            return this.operations.stream().filter(d -> d.operation() == operation);
        }

        public Stream<EntityOperation> stream(EntityOperation.State state) {
            return this.operations.stream().filter(d -> d.state() == state);
        }

        public Stream<EntityOperation> executed() {
            return this.operations.stream().filter(d -> d.state() != EntityOperation.State.UNCHANGED);
        }
    }

    public static enum CascadeType {
        ALL,
        INSERT,
        UPDATE,
        DELETE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

