/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.AbstractSearchResolver;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class GenericSearchResolver
extends AbstractSearchResolver
implements SearchResolver {
    private final CdsModel model;
    private Supplier<SessionContext> sessionContextSupplier;

    public GenericSearchResolver(CdsModel model) {
        this.model = model;
    }

    public GenericSearchResolver(CdsModel model, Supplier<SessionContext> sessionContextSupplier) {
        this(model);
        this.sessionContextSupplier = sessionContextSupplier;
    }

    public CqnSelect resolve(CqnSelect select) {
        select.search().ifPresent(expression -> {
            boolean ignoreLocalizedViews;
            CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
            Collection searchableRefs = GenericSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
            boolean languageIsGiven = this.sessionContextSupplier != null && this.sessionContextSupplier.get().getLocale() != null;
            boolean bl = ignoreLocalizedViews = languageIsGiven && LocaleUtils.hasLocalizedElements((CdsStructuredType)targetType, (Collection)searchableRefs) && this.allLocalizedElementsHaveAssociationToTexts(targetType, searchableRefs);
            if (ignoreLocalizedViews) {
                this.resolveUsingLocalizedAssociation(select, (CqnPredicate)expression, targetType, searchableRefs, true);
            } else {
                this.resolveUsingLocalizedView(select, (CqnPredicate)expression, targetType, searchableRefs, false);
            }
        });
        return select;
    }

    private void resolveUsingLocalizedAssociation(CqnSelect select, CqnPredicate expression, CdsStructuredType targetType, Collection<ElementRef<?>> searchableRefs, boolean ignoreLocalizedViews) {
        List allSearchableRefs = this.addRefsViaLocalizedAssociation(targetType, searchableRefs);
        CqnPredicate filter = GenericSearchResolver.searchToLikeExpression((Collection)allSearchableRefs, (CqnPredicate)expression);
        filter = GenericSearchResolver.checkForTargetTypeBeingEntityAndWrapToSubquery((CdsStructuredType)targetType, (CqnPredicate)filter, (boolean)ignoreLocalizedViews);
        GenericSearchResolver.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }
}

