/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.AbstractDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.JDBCClient;
import com.sap.cds.impl.SystemPropertyDataStoreConfiguration;
import com.sap.cds.impl.jdbc.DbContextImpl;
import com.sap.cds.impl.jdbc.DbType;
import com.sap.cds.impl.jdbc.DbTypeAnalyzer;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class JDBCDataStoreConnector
extends AbstractDataStoreConnector {
    private final TransactionManager transactionManager;

    private JDBCDataStoreConnector(CdsModel cdsModel, DbType dbType, Supplier<Connection> ds, TransactionManager transactionManager, DataStoreConfiguration dataStoreConfiguration) {
        super(cdsModel, (Context ctx) -> new JDBCClient(ctx, ds, transactionManager), DbContextImpl.dbContext(dbType, dataStoreConfiguration), dataStoreConfiguration);
        this.transactionManager = transactionManager;
    }

    @Deprecated
    public JDBCDataStoreConnector(CdsModel cdsModel, Supplier<Connection> ds, TransactionManager transactionManager) {
        this(cdsModel, JDBCDataStoreConnector.getDbType(ds), ds, transactionManager, new SystemPropertyDataStoreConfiguration());
    }

    @Deprecated
    public JDBCDataStoreConnector(CdsModel cdsModel, DataSource ds, TransactionManager transactionManager) {
        this(cdsModel, () -> {
            try {
                return ds.getConnection();
            }
            catch (SQLException e) {
                throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
            }
        }, transactionManager);
    }

    private JDBCDataStoreConnector(CdsModel cdsModel, Supplier<Connection> ds, TransactionManager transactionManager, DataStoreConfiguration dataStoreConfiguration) {
        this(cdsModel, JDBCDataStoreConnector.getDbType(ds), ds, transactionManager, dataStoreConfiguration);
    }

    private static DbType getDbType(Supplier<Connection> ds) {
        DbType dbType;
        try (Connection conn = ds.get();){
            dbType = DbTypeAnalyzer.analyze(conn);
        }
        catch (SQLException e) {
            throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
        }
        return dbType;
    }

    public static Builder create(CdsModel model, TransactionManager transactionManager) {
        return new Builder(model, transactionManager);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public static class Builder {
        private final CdsModel model;
        private final TransactionManager transactionManager;
        private Supplier<Connection> connectionSupplier;
        private DataStoreConfiguration dataStoreConfiguration = new SystemPropertyDataStoreConfiguration();

        private Builder(CdsModel model, TransactionManager transactionManager) {
            this.model = model;
            this.transactionManager = transactionManager;
        }

        public Builder datasource(DataSource datasource) {
            this.connectionSupplier = () -> {
                try {
                    return datasource.getConnection();
                }
                catch (SQLException e) {
                    throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
                }
            };
            return this;
        }

        public Builder connection(Supplier<Connection> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
            return this;
        }

        public Builder config(DataStoreConfiguration dataStoreConfiguration) {
            this.dataStoreConfiguration = dataStoreConfiguration;
            return this;
        }

        public JDBCDataStoreConnector build() {
            return new JDBCDataStoreConnector(this.model, this.connectionSupplier, this.transactionManager, this.dataStoreConfiguration);
        }
    }
}

