/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.DeleteStatementBuilder;
import com.sap.cds.impl.sql.InsertStatementBuilder;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.UpdateStatementBuilder;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsModel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;

public class JdbcDataSourceAdapter
implements SQLDataSourceAdapter {
    private static final ArrayDeque<QatSelectableNode> ROOT = new ArrayDeque();
    private final Context context;

    public JdbcDataSourceAdapter(Context context) {
        this.context = context;
    }

    private SQLStatementBuilder.SQLStatement appendCollation(SQLStatementBuilder.SQLStatement sqlStatement, CqnStatement statement) {
        Locale locale = this.context.getSessionContext().getLocale();
        Optional<Object> collateClause = LocaleUtils.collateClauseIsNeeded((CdsModel)this.context.getCdsModel(), (CqnStatement)statement, (Locale)locale) ? this.context.getDbContext().getStatementResolver().collateClause(statement, locale) : Optional.empty();
        if (collateClause.isPresent()) {
            String sql = String.join((CharSequence)" ", sqlStatement.sql(), (CharSequence)collateClause.get());
            return new SQLStatementBuilder.SQLStatement(sql, sqlStatement.params());
        }
        return sqlStatement;
    }

    @Override
    public SQLStatementBuilder.SQLStatement process(CqnStatement statement) {
        if (statement.isSelect()) {
            CqnSelect select = statement.asSelect();
            return this.appendCollation(new SelectStatementBuilder(this.context, new ArrayList<PreparedCqnStmt.Parameter>(), select, ROOT).build(), (CqnStatement)select);
        }
        if (statement.isInsert()) {
            return new InsertStatementBuilder(this.context, statement.asInsert()).build();
        }
        if (statement.isUpdate()) {
            return this.appendCollation(new UpdateStatementBuilder(this.context, statement.asUpdate()).build(), (CqnStatement)statement.asUpdate());
        }
        if (statement.isDelete()) {
            return this.appendCollation(new DeleteStatementBuilder(this.context, statement.asDelete()).build(), (CqnStatement)statement.asDelete());
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }
}

