/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsException;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PreparedCqnStmt
implements PreparedCqnStatement {
    private final CqnStructuredTypeRef ref;
    private final CdsStructuredType targetType;
    private final String nativeStatement;
    private final List<CqnSelectListItem> selectListItems = new ArrayList<CqnSelectListItem>();
    private final List<String> excluding = new ArrayList<String>();
    private final List<Parameter> params;

    private PreparedCqnStmt(CqnStructuredTypeRef ref, CdsStructuredType targetType, String nativeStatement, List<CqnSelectListItem> selectListItems, List<String> excluding, List<Parameter> parameters) {
        this.ref = ref;
        this.targetType = targetType;
        this.nativeStatement = nativeStatement;
        this.params = parameters;
        this.selectListItems.addAll(selectListItems);
        this.excluding.addAll(excluding);
    }

    public static PreparedCqnStmt create(String nativeStatement, List<CqnSelectListItem> selectListItems, List<String> excluding, List<Parameter> parameters, CqnStructuredTypeRef ref, CdsStructuredType targetType) {
        return new PreparedCqnStmt(ref, targetType, nativeStatement, selectListItems, excluding, parameters);
    }

    public static PreparedCqnStmt createUpdate(String nativeStatement, List<Parameter> parameters, CqnStructuredTypeRef ref, CdsEntity entity) {
        return new PreparedCqnStmt(ref, (CdsStructuredType)entity, nativeStatement, Collections.emptyList(), Collections.emptyList(), parameters);
    }

    protected String toNative() {
        return this.nativeStatement;
    }

    public List<CqnSelectListItem> selectListItems() {
        return Collections.unmodifiableList(this.selectListItems);
    }

    public List<String> excluding() {
        return Collections.unmodifiableList(this.excluding);
    }

    public CdsStructuredType targetType() {
        return this.targetType;
    }

    public CqnStructuredTypeRef ref() {
        return this.ref;
    }

    public String toString() {
        return this.nativeStatement;
    }

    public List<Parameter> parameters() {
        return this.params;
    }

    public static class ValueParam
    extends Parameter {
        final Object value;

        public ValueParam(Object value) {
            this.value = value;
        }

        @Override
        public Object get(Map<String, Object> cqnParameters) {
            return this.value;
        }

        @Override
        public String name() {
            return this.value != null ? this.value.toString() : "null";
        }
    }

    public static class DataParam
    extends Parameter {
        final String name;

        public DataParam(String name, CdsBaseType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public Object get(Map<String, Object> values) {
            return values.get(this.name);
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    public static class CqnParam
    extends Parameter {
        final String name;
        final Object defaultValue;

        public CqnParam(String name) {
            this(name, null);
        }

        public CqnParam(String name, Object defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object get(Map<String, Object> values) {
            if (values.containsKey(this.name)) {
                return values.get(this.name);
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new CdsException("Missing value for parameter " + this.name);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }
    }

    public static abstract class Parameter {
        protected CdsBaseType type;

        public abstract Object get(Map<String, Object> var1);

        public abstract String name();

        public Optional<Object> defaultValue() {
            return Optional.empty();
        }

        public CdsBaseType type() {
            return this.type;
        }

        public String toString() {
            return this.name();
        }

        public Parameter type(Optional<String> type) {
            this.type = type.map(CdsBaseType::cdsType).orElse(null);
            return this;
        }

        public Parameter type(CdsBaseType type) {
            this.type = type;
            return this;
        }
    }
}

