/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.GenericSearchResolver;
import com.sap.cds.impl.LocalizedViewSearchResolver;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.impl.SystemPropertyDataStoreConfiguration;
import com.sap.cds.impl.jdbc.DbContext;
import com.sap.cds.impl.jdbc.DbType;
import com.sap.cds.impl.jdbc.ExceptionAnalyzer;
import com.sap.cds.impl.jdbc.GenericBinder;
import com.sap.cds.impl.jdbc.GenericStatementResolver;
import com.sap.cds.impl.jdbc.GenericTableNameResolver;
import com.sap.cds.impl.jdbc.IsDistinctFromMapper;
import com.sap.cds.impl.jdbc.JDBCBinder;
import com.sap.cds.impl.jdbc.h2.H2Context;
import com.sap.cds.impl.jdbc.hana.HanaContext;
import com.sap.cds.impl.jdbc.postgresql.PostgreSqlContext;
import com.sap.cds.impl.jdbc.sqlite.SqliteContext;
import com.sap.cds.impl.qat.StatementResolver;
import com.sap.cds.impl.qat.TableNameResolver;
import com.sap.cds.impl.sql.FunctionMapper;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbContextImpl
implements DbContext {
    private static final DataStoreConfiguration systemPropertyDataStoreConfiguration = new SystemPropertyDataStoreConfiguration();
    private final DbType type;
    private final TableNameResolver tableNameResolver;
    private final FunctionMapper functionMapper;
    private final UnaryOperator<CqnPredicate> predicateMapper;
    private final StatementResolver statementResolver;
    private final ExceptionAnalyzer exceptionAnalyzer;
    private final CdsDataStoreConnector.Capabilities capabilities;
    private final BiFunction<CdsModel, Supplier<SessionContext>, SearchResolver> searchResolver;
    private final JDBCBinder binder;

    private DbContextImpl(DbType type, TableNameResolver tableNameResolver, FunctionMapper functionMapper, UnaryOperator<CqnPredicate> predicateMapper, StatementResolver statementResolver, ExceptionAnalyzer exceptionAnalyzer, CdsDataStoreConnector.Capabilities capabilities, BiFunction<CdsModel, Supplier<SessionContext>, SearchResolver> searchResolver, JDBCBinder binder) {
        this.type = type;
        this.tableNameResolver = tableNameResolver;
        this.functionMapper = functionMapper;
        this.predicateMapper = predicateMapper;
        this.statementResolver = statementResolver;
        this.exceptionAnalyzer = exceptionAnalyzer;
        this.capabilities = capabilities;
        this.searchResolver = searchResolver;
        this.binder = binder;
    }

    public static DbContext dbContext() {
        return DbContextImpl.create(DbType.OTHER).build();
    }

    private static DbContext dbContext(DataStoreConfiguration dataStoreConfiguration) {
        return DbContextImpl.create(DbType.OTHER, dataStoreConfiguration).build();
    }

    public static DbContext dbContext(DbType dbType) {
        return DbContextImpl.dbContext(dbType, systemPropertyDataStoreConfiguration);
    }

    public static DbContext dbContext(DbType dbType, DataStoreConfiguration dataStoreConfiguration) {
        switch (dbType) {
            case HANA: {
                return HanaContext.getInstance(dataStoreConfiguration);
            }
            case SQLITE: {
                return SqliteContext.getInstance(dataStoreConfiguration);
            }
            case H2: {
                return H2Context.getInstance(dataStoreConfiguration);
            }
            case POSTGRES: {
                return PostgreSqlContext.getInstance(dataStoreConfiguration);
            }
        }
        return DbContextImpl.dbContext(dataStoreConfiguration);
    }

    public static Builder create(DbType type) {
        return new Builder(type, systemPropertyDataStoreConfiguration);
    }

    public static Builder create(DbType type, DataStoreConfiguration dataStoreConfiguration) {
        return new Builder(type, dataStoreConfiguration);
    }

    @Override
    public DbType getDbType() {
        return this.type;
    }

    @Override
    public TableNameResolver getTableResolver() {
        return this.tableNameResolver;
    }

    @Override
    public SearchResolver getSearchResolver(CdsModel model, Supplier<SessionContext> sessionContextSupplier) {
        return this.searchResolver.apply(model, sessionContextSupplier);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public UnaryOperator<CqnPredicate> getPredicateMapper() {
        return this.predicateMapper;
    }

    @Override
    public StatementResolver getStatementResolver() {
        return this.statementResolver;
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return this.exceptionAnalyzer;
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public JDBCBinder getBinder() {
        return this.binder;
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private final DbType type;
        private final DataStoreConfiguration dataStoreConfiguration;
        private TableNameResolver tableNameResolver;
        private FunctionMapper functionMapper = new FunctionMapper();
        private UnaryOperator<CqnPredicate> predicateMapper = new IsDistinctFromMapper();
        private StatementResolver statementResolver = new GenericStatementResolver();
        private BiFunction<CdsModel, Supplier<SessionContext>, SearchResolver> searchResolver;
        private JDBCBinder binder = new GenericBinder();
        private ExceptionAnalyzer exceptionAnalyzer = new ExceptionAnalyzer(){};
        private CdsDataStoreConnector.Capabilities capabilities = new CdsDataStoreConnector.Capabilities(){};

        public Builder(DbType type, DataStoreConfiguration dataStoreConfiguration) {
            this.type = type;
            this.dataStoreConfiguration = dataStoreConfiguration;
            this.tableNameResolver = new GenericTableNameResolver(dataStoreConfiguration);
            this.searchResolver = GenericSearchResolver::new;
        }

        public DbContext build() {
            boolean useGenericSearchResolver = Boolean.parseBoolean(this.dataStoreConfiguration.getProperty("cds.sql.search.use-localized-view", "false"));
            if (useGenericSearchResolver) {
                this.searchResolver = LocalizedViewSearchResolver::new;
                logger.debug("Switched to LocalizedViewSearchResolver due to provided configuration.");
            }
            return new DbContextImpl(this.type, this.tableNameResolver, this.functionMapper, this.predicateMapper, this.statementResolver, this.exceptionAnalyzer, this.capabilities, this.searchResolver, this.binder);
        }

        public Builder setTableNameResolver(TableNameResolver tableNameResolver) {
            this.tableNameResolver = tableNameResolver;
            return this;
        }

        public Builder setStatementResolver(StatementResolver statementResolver) {
            this.statementResolver = statementResolver;
            return this;
        }

        public Builder setExceptionAnalyzer(ExceptionAnalyzer exceptionAnalyzer) {
            this.exceptionAnalyzer = exceptionAnalyzer;
            return this;
        }

        public Builder setFunctionMapper(FunctionMapper functionMapper) {
            this.functionMapper = functionMapper;
            return this;
        }

        public Builder setPredicateMapper(UnaryOperator<CqnPredicate> predicateMapper) {
            this.predicateMapper = predicateMapper;
            return this;
        }

        public Builder setCapabilities(CdsDataStoreConnector.Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder setSearchResolver(BiFunction<CdsModel, Supplier<SessionContext>, SearchResolver> searchResolver) {
            this.searchResolver = searchResolver;
            return this;
        }

        public Builder setBinder(JDBCBinder binder) {
            this.binder = binder;
            return this;
        }
    }

    @FunctionalInterface
    public static interface SearchResolverCreator<model, context, config, resolver> {
        public resolver apply(model var1, context var2, config var3);
    }
}

