/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.jdbc.hana;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.AbstractSearchResolver;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.draft.DraftUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaSearchResolver
extends AbstractSearchResolver
implements SearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolver.class);
    private final CdsModel model;
    private Supplier<SessionContext> sessionContextSupplier;
    private boolean inSubquery = false;

    public HanaSearchResolver(CdsModel model) {
        this.model = model;
    }

    public HanaSearchResolver(CdsModel model, Supplier<SessionContext> sessionContextSupplier) {
        this(model);
        this.sessionContextSupplier = sessionContextSupplier;
    }

    private static boolean isActiveEntity(CdsStructuredType targetType) {
        return DraftUtils.isDraftEnabled(targetType) && !DraftUtils.isDraftView(targetType);
    }

    private static boolean anyRefIsDeclaredByActiveEntity(CdsStructuredType root, Collection<ElementRef<?>> refs) {
        for (ElementRef<?> ref : refs) {
            CdsStructuredType declaringType = (CdsStructuredType)CdsModelUtils.element((CdsStructuredType)root, ref).getDeclaringType();
            if (!HanaSearchResolver.isActiveEntity(declaringType)) continue;
            return true;
        }
        return false;
    }

    public CqnSelect resolve(CqnSelect select) {
        this.decorateSelectWithHanaSearchExpression(select);
        return select;
    }

    public void pushDownSearchToSubquery(CqnSelect select, CqnSelect subquery) {
        this.inSubquery = true;
        CqnPredicate merged = (CqnPredicate)Conjunction.and((Optional)subquery.asSelect().search(), (Optional)select.search()).orElse(CqnBoolLiteral.TRUE);
        ((SelectBuilder)subquery.asSelect()).search(merged);
        ((SelectBuilder)select).search((CqnPredicate)null);
    }

    private void decorateSelectWithHanaSearchExpression(CqnSelect select) {
        select.search().ifPresent(search -> {
            CqnPredicate filter;
            boolean useLocalizedAssociationForTextResolution;
            CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
            List searchableRefs = this.getSearchableElementRefsConsideringIncludeList(select, targetType);
            boolean languageGiven = this.sessionContextSupplier != null && this.sessionContextSupplier.get().getLocale() != null;
            boolean hasLocalizedElements = LocaleUtils.hasLocalizedElements((CdsStructuredType)targetType, searchableRefs);
            boolean searchedCalculatedFields = this.searchesCalculatedFields(select, searchableRefs);
            boolean bl = useLocalizedAssociationForTextResolution = languageGiven && hasLocalizedElements && this.allLocalizedElementsHaveAssociationToTexts(targetType, searchableRefs);
            if (useLocalizedAssociationForTextResolution) {
                searchableRefs = this.addRefsViaLocalizedAssociation(targetType, searchableRefs);
            }
            if (languageGiven && hasLocalizedElements && !useLocalizedAssociationForTextResolution || searchedCalculatedFields) {
                filter = this.searchToHanaLikeFallback((CqnPredicate)search, searchableRefs);
                logger.warn("Search over localized view '{}' may have a negative performance impact. Activate debug log for more details.", (Object)targetType);
                logger.debug("Fallback to LIKE over the localized view of {}. The following conditions lead to the operation: language: {}, hasLocalizedElements: {}, useLocalizedAssociationForTextResolution: {}, searchesCalculatedFields: {}", new Object[]{targetType, languageGiven, hasLocalizedElements, useLocalizedAssociationForTextResolution, searchedCalculatedFields});
            } else {
                filter = this.searchToHanaContains(searchableRefs, (CqnPredicate)search);
            }
            boolean isActiveEntityOfDraft = HanaSearchResolver.anyRefIsDeclaredByActiveEntity(targetType, searchableRefs);
            if (useLocalizedAssociationForTextResolution || HanaSearchResolver.anyRefViaCollectionAssociation((CdsStructuredType)targetType, (Collection)searchableRefs) || isActiveEntityOfDraft) {
                filter = HanaSearchResolver.checkForTargetTypeBeingEntityAndWrapToSubquery((CdsStructuredType)targetType, (CqnPredicate)filter, (boolean)useLocalizedAssociationForTextResolution);
            }
            HanaSearchResolver.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
        });
        this.inSubquery = false;
    }

    private boolean searchesCalculatedFields(CqnSelect select, Collection<? extends CqnElementRef> searchableRefs) {
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.ref());
        if (!entity.query().isPresent()) {
            return false;
        }
        Set searchableRefNames = searchableRefs.stream().map(CqnSelectListValue::displayName).collect(Collectors.toSet());
        CqnSelect entityQuery = (CqnSelect)entity.query().get();
        Collection localSearchableValues = entityQuery.items().stream().filter(CqnSelectListItem::isValue).map(CqnSelectListItem::asValue).filter(slv -> searchableRefNames.contains(slv.displayName())).collect(Collectors.toList());
        boolean searchesCalculatedField = localSearchableValues.stream().anyMatch(slv -> !slv.value().isRef());
        if (searchesCalculatedField) {
            return true;
        }
        if (!localSearchableValues.isEmpty()) {
            searchableRefs = localSearchableValues.stream().map(slv -> slv.value().asRef()).collect(Collectors.toList());
        }
        if (!entityQuery.from().isRef()) {
            return true;
        }
        return this.searchesCalculatedFields(entityQuery, searchableRefs);
    }

    private CqnPredicate searchToHanaLikeFallback(CqnPredicate search, Collection<ElementRef<?>> searchableRefs) {
        CqnPredicate filter = HanaSearchResolver.searchToLikeExpression(searchableRefs, (CqnPredicate)search);
        return filter;
    }

    private Collection<ElementRef<?>> getSearchableElementRefsConsideringIncludeList(CqnSelect select, CdsStructuredType targetType) {
        Set including = select.items().stream().filter(CqnSelectListItem::isValue).map(item -> item.asValue().value()).filter(CqnValue::isRef).map(val -> val.asRef().lastSegment()).collect(Collectors.toSet());
        Collection searchableRefs = this.inSubquery ? (Collection)HanaSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType).stream().filter(elementRef -> including.contains(elementRef.lastSegment())).collect(Collectors.toList()) : HanaSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
        return searchableRefs;
    }

    private CqnPredicate searchToHanaContains(Collection<ElementRef<?>> searchableRefs, CqnPredicate expression) {
        if (searchableRefs.isEmpty()) {
            return CqnBoolLiteral.FALSE;
        }
        ListValue refs = ListValue.of(searchableRefs);
        CqnValue searchExpression = this.cqnSearchPredicateToHanaContainsSearchString(expression);
        return CQL.booleanFunc((String)"CONTAINS", Arrays.asList(refs, searchExpression));
    }

    private CqnValue cqnSearchPredicateToHanaContainsSearchString(CqnPredicate expression) {
        final Stack stack = new Stack();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchPredicate search) {
                stack.push((Object)String.format("*%s*", search.searchTerm()));
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                String delimiter = connective.operator() == CqnConnectivePredicate.Operator.AND ? " " : " OR ";
                stack.push((Object)String.join((CharSequence)delimiter, stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push((Object)("-" + (String)stack.pop()));
            }
        };
        expression.accept(visitor);
        if (stack.isEmpty()) {
            throw new IllegalStateException("the search term stack must not be empty!");
        }
        return CQL.val((Object)stack.pop());
    }
}

