/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.qat.QatStructuredNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.List;
import java.util.Optional;

public class QatBuilder {
    private static final int T = 84;
    private final CqnSelect select;
    private final int queryDepth;
    private final QatSelectableNode root;

    public QatBuilder(Context context, CqnSelect select, int queryDepth) {
        this.select = select;
        this.queryDepth = queryDepth;
        CqnSource source = select.from();
        if (source.isRef()) {
            CqnReference.Segment rootSegment = source.asRef().rootSegment();
            CdsEntity rootEntity = context.getCdsModel().getEntity(rootSegment.id());
            this.root = new QatEntityRootNode(rootEntity, rootSegment.filter());
        } else if (source.isSelect()) {
            CdsStructuredType rowType = CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSelect)source.asSelect());
            this.root = new QatSelectRootNode(source.asSelect(), rowType);
        } else {
            throw new UnsupportedOperationException("Joins are not supported");
        }
    }

    public QatSelectableNode create() {
        this.collectRefs();
        this.assignTableAliases();
        return this.root;
    }

    private void assignTableAliases() {
        QatVisitor assignAlias = new QatVisitor(){
            int i = 0;

            @Override
            public void visit(QatSelectableNode root) {
                this.assignAlias(root);
            }

            @Override
            public void visit(QatAssociationNode association) {
                this.assignAlias(association);
            }

            private void assignAlias(QatSelectableNode node) {
                node.setAlias(String.valueOf((char)(84 + QatBuilder.this.queryDepth)) + this.i++);
            }
        };
        QatTraverser.take(assignAlias).traverse(this.root);
    }

    private void collectRefs() {
        this.select.accept((CqnVisitor)new CollectRefsVisitor());
    }

    class CollectRefsVisitor
    implements CqnVisitor {
        private AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
        private QatNode rootPath = QatBuilder.access$100(QatBuilder.this);

        CollectRefsVisitor() {
        }

        public void visit(CqnStructuredTypeRef ref) {
            this.rootPath = this.followRef(QatBuilder.this.root, ref.segments(), true);
            ref.targetSegment().filter().ifPresent(f -> f.accept((CqnVisitor)this));
        }

        public void visit(CqnElementRef ref) {
            if (!ref.firstSegment().equals("$outer") && !CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                this.followRef(this.rootPath, ref.segments(), false);
            }
        }

        public void visit(CqnContainmentTest test) {
            test.args().forEach(a -> a.accept((CqnVisitor)this));
        }

        private QatNode followRef(QatNode rootNode, List<? extends CqnReference.Segment> segments, boolean inSource) {
            QatNode current = rootNode;
            boolean firstSegment = true;
            for (CqnReference.Segment segment : segments) {
                QatNode child;
                CdsStructuredType rowType = ((QatStructuredNode)current).rowType();
                if (firstSegment && segment.id().equals(rowType.getQualifiedName())) continue;
                CdsElement element = rowType.getElement(segment.id());
                CdsType type = element.getType();
                Optional filter = Optional.empty();
                if (type.isAssociation()) {
                    QatAssociation assoc = this.handleAssociation(element);
                    child = new QatAssociationNode(current, assoc, (Optional<CqnPredicate>)segment.filter(), inSource);
                    filter = segment.filter();
                } else if (type.isStructured()) {
                    child = new QatStructuredElementNode(current, element);
                } else if (!inSource) {
                    child = new QatElementNode(current, element);
                } else {
                    throw new IllegalStateException("Ref segment " + segment.id() + " is expected to be an association");
                }
                current = current.addChild(child, filter);
                firstSegment = false;
            }
            return current;
        }

        public void visit(CqnSortSpecification sortSpec) {
            sortSpec.item().accept((CqnVisitor)this);
        }

        private QatAssociation handleAssociation(CdsElement association) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            CqnPredicate on = this.associationAnalyzer.getOnCondition(association);
            return new QatAssociation(target, association.getName(), on);
        }
    }
}

