/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;

public class Ref2QualifiedColumn
implements Function<CqnElementRef, String> {
    private final QatSelectableNode root;
    private final QatSelectableNode outerTable;
    private final String rootName;

    public Ref2QualifiedColumn(Deque<QatSelectableNode> outer) {
        Iterator<QatSelectableNode> reverse = outer.descendingIterator();
        this.root = Ref2QualifiedColumn.qatRoot(reverse.next());
        this.rootName = this.root.rowType().getQualifiedName();
        this.outerTable = reverse.hasNext() ? Ref2QualifiedColumn.qatRoot(reverse.next()) : null;
    }

    @Override
    public String apply(CqnElementRef ref) {
        String tableAlias;
        String columnName;
        QatNode node = this.root;
        boolean firstSegment = true;
        if (ref.firstSegment().equals("$outer")) {
            CdsStructuredType rowType = this.outerTable.rowType();
            columnName = SqlMapping.columnName(rowType.getElement(ref.lastSegment()));
            tableAlias = this.outerTable.alias();
        } else {
            for (CqnReference.Segment s : ref.segments()) {
                if (firstSegment && s.id().equals(this.rootName)) continue;
                node = node.child(s.id(), s.filter());
                Ref2QualifiedColumn.assertNotNull(ref, node);
                firstSegment = false;
            }
            if (node instanceof QatElementNode) {
                columnName = this.columnName(node);
            } else {
                throw new CqnValidationException(node.name() + " does not refer to an element");
            }
            while ((node = node.parent()) != null && !(node instanceof QatSelectableNode)) {
            }
            Ref2QualifiedColumn.assertNotNull(ref, node);
            tableAlias = ((QatSelectableNode)node).alias();
        }
        return Ref2QualifiedColumn.column(tableAlias, columnName);
    }

    private static String column(String alias, String col) {
        return alias + "." + col;
    }

    private static QatSelectableNode qatRoot(QatNode root) {
        Optional<QatNode> src = Optional.ofNullable(root);
        while (src.isPresent()) {
            root = src.get();
            src = root.children().stream().filter(QatNode::inSource).findFirst();
        }
        return (QatSelectableNode)root;
    }

    private String columnName(QatNode node) {
        QatElementNode elementNode = (QatElementNode)node;
        CdsElement cdsElement = elementNode.element();
        return SqlMapping.columnName(cdsElement);
    }

    private static void assertNotNull(CqnElementRef ref, QatNode node) {
        if (node == null) {
            throw new CqnValidationException("Unresolvable path expression: " + ref.toJson());
        }
    }
}

