/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FunctionMapper {
    private static final char ESCAPE_CHAR = '\\';

    public String toSql(String cqnFunc, List<String> args) {
        String func;
        switch (func = cqnFunc.toLowerCase(Locale.US)) {
            case "countdistinct": {
                return "COUNT(DISTINCT " + args.get(0) + ")";
            }
            case "tolower": {
                return this.genericFuncToSql("LOWER", args);
            }
            case "toupper": {
                return this.genericFuncToSql("UPPER", args);
            }
            case "current_date": {
                return "current_date";
            }
            case "current_time": {
                return "current_time";
            }
            case "current_timestamp": {
                return "current_timestamp";
            }
            case "singlevalue": {
                String col = args.get(0);
                return MessageFormat.format("(case when min({0}) = max({0}) then min ({0}) end)", col);
            }
            case "count": {
                if (!args.isEmpty()) break;
                return "COUNT(*)";
            }
        }
        return this.genericFuncToSql(cqnFunc, args);
    }

    public String toSql(Function<CqnToken, String> toSQL, CqnContainmentTest cqnCTest) {
        CqnValue value = cqnCTest.value();
        CqnValue term = cqnCTest.term();
        if (cqnCTest.caseInsensitive()) {
            value = CQL.func((String)"tolower", (CqnValue[])new CqnValue[]{value});
            term = CQL.func((String)"tolower", (CqnValue[])new CqnValue[]{term});
        }
        String valueSql = toSQL.apply((CqnToken)value);
        term = this.escapeTerm(cqnCTest.func().toLowerCase(Locale.US), term);
        String patternSql = toSQL.apply((CqnToken)term);
        return valueSql + " LIKE " + patternSql + " ESCAPE " + SQLHelper.literal('\\');
    }

    CqnValue escapeTerm(final String func, CqnValue term) {
        return ExpressionVisitor.copy((CqnValue)term, (Modifier)new Modifier(){

            public CqnValue literal(CqnLiteral<?> literal) {
                if (literal.isString()) {
                    String term = SQLHelper.escapeLikePattern('\\', (String)literal.asString().value());
                    switch (func) {
                        case "startswith": {
                            term = term + '%';
                            break;
                        }
                        case "contains": {
                            term = '%' + term + '%';
                            break;
                        }
                        case "endswith": {
                            term = '%' + term;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unexpected function: " + func);
                        }
                    }
                    return super.literal((CqnLiteral)CQL.val((Object)term));
                }
                return literal;
            }
        });
    }

    protected String genericFuncToSql(String func, List<String> args) {
        return func.toUpperCase(Locale.US) + args.stream().collect(Collectors.joining(", ", "(", ")"));
    }
}

