/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InsertStatementBuilder
implements SQLStatementBuilder {
    private final CqnInsert insert;
    private final SqlMapping sqlMapping;
    private final CdsEntity entity;

    public InsertStatementBuilder(Context context, CqnInsert insert) {
        this.insert = insert;
        CqnStructuredTypeRef ref = insert.ref();
        this.entity = context.getCdsModel().getEntity(ref.firstSegment());
        this.sqlMapping = new SqlMapping((CdsStructuredType)this.entity);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        ArrayList<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();
        params.addAll(0, this.insert.elements().map(n -> {
            CdsBaseType type = this.entity.findElement(n).filter(e -> e.getType().isSimple()).map(e -> ((CdsSimpleType)e.getType().as(CdsSimpleType.class)).getType()).orElse(null);
            return new PreparedCqnStmt.DataParam((String)n, type);
        }).collect(Collectors.toList()));
        String tableName = this.sqlMapping.tableName();
        String columnsString = InsertStatementBuilder.commaSeparated(this.insert.elements().map(this.sqlMapping::columnName));
        String ps = InsertStatementBuilder.commaSeparated(this.insert.elements().map(c -> "?"));
        String sql = Stream.of("INSERT", "INTO", tableName, columnsString, "VALUES", ps).collect(Collectors.joining(" "));
        return new SQLStatementBuilder.SQLStatement(sql, params);
    }

    private static String commaSeparated(Stream<String> stream) {
        return "(" + stream.collect(Collectors.joining(", ")) + ")";
    }
}

