/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubQuery;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.SubQuery;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnNumericLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStringLiteral;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSubQuery;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.Xpr;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TokenToSQLTransformer
implements Function<CqnToken, String> {
    private static final int SUBSTRING_START_PARAM = 1;
    private final Context context;
    private final List<PreparedCqnStmt.Parameter> params;
    private final Function<CqnElementRef, String> aliasResolver;
    private final Deque<QatSelectableNode> outer;
    private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
    private int parameterPosition = 0;

    public TokenToSQLTransformer(Context context, List<PreparedCqnStmt.Parameter> params, Function<CqnElementRef, String> aliasResolver, Deque<QatSelectableNode> outer) {
        this.context = context;
        this.params = params;
        this.aliasResolver = aliasResolver;
        this.outer = outer;
    }

    public TokenToSQLTransformer(Context context, Function<CqnElementRef, String> aliasResolver, CdsEntity entity, String tableName, List<PreparedCqnStmt.Parameter> params) {
        this(context, params, aliasResolver, TokenToSQLTransformer.outerQat(entity, tableName));
    }

    private static Deque<QatSelectableNode> outerQat(CdsEntity entity, String tableName) {
        QatEntityRootNode root = new QatEntityRootNode(entity);
        root.setAlias(tableName);
        ArrayDeque<QatSelectableNode> outer = new ArrayDeque<QatSelectableNode>();
        outer.add(root);
        return outer;
    }

    public String toSQL(CqnPredicate pred) {
        pred = (CqnPredicate)this.context.getDbContext().getPredicateMapper().apply(pred);
        if ((pred = CqnStatementUtils.simplifyPredicate((CqnPredicate)pred)) == CqnBoolLiteral.TRUE) {
            return null;
        }
        if (pred == CqnBoolLiteral.FALSE) {
            return "1 = 0";
        }
        return this.apply((CqnToken)pred);
    }

    @Override
    public String apply(CqnToken pred) {
        if (pred == null) {
            throw new IllegalArgumentException("predicate must not be null");
        }
        ToSQLVisitor visitor = new ToSQLVisitor();
        pred.accept((CqnVisitor)visitor);
        String sql = visitor.get(pred);
        if (pred instanceof Xpr) {
            sql = sql.substring(1, sql.length() - 1);
        }
        return sql;
    }

    class ToSQLVisitor
    implements CqnVisitor {
        Stack<String> stack = new Stack();

        ToSQLVisitor() {
        }

        public void visit(CqnParameter p) {
            String name = p.isPositional() ? String.valueOf(TokenToSQLTransformer.this.parameterPosition++) : p.name();
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.CqnParam(name).type(p.type());
            TokenToSQLTransformer.this.params.add(param);
            this.push("?");
        }

        public void visit(CqnFunc cqnFunc) {
            String func = cqnFunc.func().toLowerCase(Locale.US);
            List args = this.stack.pop(cqnFunc.args().size());
            if ("substring".equals(func)) {
                args.set(1, (String)args.get(1) + " + 1");
            }
            this.push(TokenToSQLTransformer.this.context.getDbContext().getFunctionMapper().toSql(func, args));
        }

        public void visit(CqnListValue listValue) {
            int n = (int)listValue.values().count();
            String sql = this.stack.pop(n).stream().collect(Collectors.joining(", ", "(", ")"));
            this.push(sql);
        }

        public void visit(CqnContainmentTest test) {
            this.push(TokenToSQLTransformer.this.context.getDbContext().getFunctionMapper().toSql(TokenToSQLTransformer.this, test));
        }

        public void visit(CqnPlain plain) {
            this.push(plain.plain());
        }

        public void visit(CqnBooleanLiteral bool) {
            this.push(Boolean.TRUE.equals(bool.value()) ? "TRUE" : "FALSE");
        }

        public void visit(CqnNumericLiteral<?> number) {
            Number val = number.value();
            if (number.isConstant() && this.isNonDecimal(val)) {
                this.push(String.valueOf(val));
            } else {
                this.valueParam((CqnLiteral<?>)number);
            }
        }

        private boolean isNonDecimal(Number number) {
            return number instanceof Integer || number instanceof Long || number instanceof Short;
        }

        public void visit(CqnStringLiteral literal) {
            if (literal.isConstant()) {
                this.push(SQLHelper.literal((String)literal.value()));
            } else {
                this.valueParam((CqnLiteral<?>)literal);
            }
        }

        public void visit(CqnLiteral<?> literal) {
            this.valueParam(literal);
        }

        private void valueParam(CqnLiteral<?> literal) {
            PreparedCqnStmt.Parameter p = new PreparedCqnStmt.ValueParam(literal.value()).type(literal.type());
            TokenToSQLTransformer.this.params.add(p);
            this.push("?");
        }

        private void valueParam(Object value, CdsBaseType type) {
            PreparedCqnStmt.Parameter p = new PreparedCqnStmt.ValueParam(value).type(type);
            TokenToSQLTransformer.this.params.add(p);
            this.push("?");
        }

        public void visit(CqnNullValue nil) {
            this.push("NULL");
        }

        public void visit(CqnElementRef ref) {
            if (CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                switch (ref.firstSegment()) {
                    case "$now": {
                        this.valueParam(TokenToSQLTransformer.this.context.getSessionContext().getNow(), CdsBaseType.TIMESTAMP);
                        break;
                    }
                    case "$at": {
                        if (ref.lastSegment().equalsIgnoreCase("from")) {
                            this.valueParam(TokenToSQLTransformer.this.context.getSessionContext().getValidFrom(), CdsBaseType.TIMESTAMP);
                            break;
                        }
                        if (ref.lastSegment().equalsIgnoreCase("to")) {
                            this.valueParam(TokenToSQLTransformer.this.context.getSessionContext().getValidTo(), CdsBaseType.TIMESTAMP);
                            break;
                        }
                        throw this.badRef(ref);
                    }
                    case "$user": {
                        if (ref.lastSegment().equalsIgnoreCase("locale")) {
                            this.valueParam(LocaleUtils.getLocaleString((Locale)TokenToSQLTransformer.this.context.getSessionContext().getLocale()), CdsBaseType.STRING);
                            break;
                        }
                        if (ref.lastSegment().equalsIgnoreCase("id")) {
                            this.valueParam(TokenToSQLTransformer.this.context.getSessionContext().getUserContext().getId(), CdsBaseType.STRING);
                            break;
                        }
                        throw this.badRef(ref);
                    }
                    default: {
                        throw this.badRef(ref);
                    }
                }
            } else {
                this.push((String)TokenToSQLTransformer.this.aliasResolver.apply(ref));
            }
        }

        private CqnSyntaxException badRef(CqnElementRef ref) {
            return new CqnSyntaxException("The reference " + ref.toJson() + " can't be resolved");
        }

        public void visit(CqnSubQuery query) {
            ArrayDeque<QatEntityRootNode> outerNodes;
            SubQuery subQuery = (SubQuery)query;
            if (subQuery.getOuterAlias() != null) {
                ArrayDeque<QatEntityRootNode> parentNode = new ArrayDeque<QatEntityRootNode>();
                QatEntityRootNode outerNode = new QatEntityRootNode(subQuery.getOuterEntity());
                outerNode.setAlias(subQuery.getOuterAlias());
                parentNode.add(outerNode);
                outerNodes = parentNode;
            } else {
                outerNodes = TokenToSQLTransformer.this.outer;
            }
            SQLStatementBuilder.SQLStatement stmt = new SelectStatementBuilder(TokenToSQLTransformer.this.context, TokenToSQLTransformer.this.params, query.query(), (Deque<QatSelectableNode>)outerNodes).build();
            this.push("EXISTS (" + stmt.sql() + ")");
        }

        public void visit(CqnMatchPredicate matchPredicate) {
            MatchPredicate match = (MatchPredicate)matchPredicate;
            CqnStructuredTypeRef ref = match.ref();
            CqnMatchPredicate.Quantifier quantifier = match.quantifier();
            final CdsElement association = this.getAssociation(ref);
            final CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            ref = ExpressionVisitor.copy((CqnStructuredTypeRef)ref, (Modifier)new Modifier(){

                public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                    ref.rootSegment().id(target.getQualifiedName());
                    return ref;
                }
            });
            Select subquery = Select.from((CqnStructuredTypeRef)ref);
            CqnPredicate on = TokenToSQLTransformer.this.associationAnalyzer.getOnCondition(association);
            Modifier m = new Modifier(){

                public Value<?> ref(ElementRef<?> ref) {
                    LinkedList<RefSegment> segments = new LinkedList<RefSegment>(ref.segments());
                    if (ref.firstSegment().equals(association.getName())) {
                        segments.remove(0);
                    } else {
                        segments.add(0, RefSegmentImpl.refSegment((String)"$outer"));
                    }
                    return ElementRefImpl.element(segments);
                }
            };
            on = ExpressionVisitor.copy((CqnPredicate)on, (Modifier)m);
            Optional<CqnPredicate> pred = match.predicate().map(p -> quantifier == CqnMatchPredicate.Quantifier.ALL ? CQL.not((CqnPredicate)p) : p);
            Conjunction.and(Optional.of(on), pred).ifPresent(arg_0 -> ((Select)subquery).where(arg_0));
            ExistsSubQuery exists = new ExistsSubQuery((CqnSelect)subquery);
            String sql = TokenToSQLTransformer.this.apply((CqnToken)exists.subquery());
            if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                this.push("not " + sql);
            } else {
                this.push(sql);
            }
        }

        private CdsElement getAssociation(CqnStructuredTypeRef ref) {
            String path;
            CqnReference.Segment segment;
            CdsElement element;
            CdsType elementType;
            CdsStructuredType rowType = ((QatSelectableNode)TokenToSQLTransformer.this.outer.getLast()).rowType();
            String root = rowType.getQualifiedName();
            Iterator iter = ref.segments().iterator();
            while ((elementType = (element = rowType.getElement((segment = (CqnReference.Segment)iter.next()).id())).getType()).isStructured()) {
                rowType = (CdsStructuredType)elementType.as(CdsStructuredType.class);
                if (iter.hasNext()) continue;
            }
            if (!elementType.isAssociation()) {
                path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
                String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", root, path);
                throw new CqnValidationException(message);
            }
            if (iter.hasNext()) {
                path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
                String message = MessageFormat.format("The reference {0}.{1} navigates multiple associations and can''t be used with the anyMatch predicate.", root, path);
                throw new UnsupportedOperationException(message);
            }
            return element;
        }

        public void visit(CqnExpression xpr) {
            List snippets = this.stack.pop(((Xpr)xpr).length());
            this.push("(" + snippets.stream().collect(SpaceSeparatedCollector.joining()) + ")");
        }

        public void visit(CqnArithmeticExpression expr) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push("(" + left + " " + expr.operator().symbol() + " " + right + ")");
        }

        public void visit(CqnComparisonPredicate comparison) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push(left + " " + comparison.operator().symbol + " " + right);
        }

        public void visit(CqnConnectivePredicate connective) {
            String symbol = connective.operator().symbol;
            BiFunction<CqnPredicate, String, String> flattener = connective.operator() == CqnConnectivePredicate.Operator.AND ? this::flatAnd : this::flatOr;
            List original = connective.predicates();
            List snippets = this.stack.pop(original.size());
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < original.size(); ++i) {
                if (i > 0) {
                    sql.append(" ");
                    sql.append(symbol);
                    sql.append(" ");
                }
                sql.append(flattener.apply((CqnPredicate)original.get(i), (String)snippets.get(i)));
            }
            this.push(sql.toString());
        }

        private String flatAnd(CqnPredicate pred, String snippet) {
            if (pred instanceof Disjunction) {
                return "(" + snippet + ")";
            }
            return snippet;
        }

        String flatOr(CqnPredicate pred, String snippet) {
            return snippet;
        }

        public void visit(CqnInPredicate in) {
            List values = this.stack.pop(in.values().size());
            String value = (String)this.stack.pop();
            this.push(value + values.stream().collect(Collectors.joining(", ", " in (", ")")));
        }

        public void visit(CqnNegation neg) {
            if (neg.predicate() instanceof CqnConnectivePredicate) {
                this.push("not (" + (String)this.stack.pop() + ")");
            } else {
                this.push("not " + (String)this.stack.pop());
            }
        }

        private void push(String snippet) {
            this.stack.push((Object)snippet);
        }

        private String get(CqnToken pred) {
            if (this.stack.size() != 1) {
                throw new IllegalStateException("token " + pred.toJson() + " can't be mapped");
            }
            return (String)this.stack.pop();
        }
    }
}

