/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpdateStatementBuilder
implements SQLStatementBuilder {
    private final CqnUpdate update;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final TokenToSQLTransformer toSQL;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();
    private final CdsEntity entity;

    public UpdateStatementBuilder(Context context, CqnUpdate update) {
        this.update = update;
        this.entity = context.getCdsModel().getEntity(update.ref().firstSegment());
        this.sqlMapping = new SqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSQL = new TokenToSQLTransformer(context, this.sqlMapping::columnName, this.entity, this.tableName, this.params);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        this.params.addAll(0, this.update.elements().map(n -> {
            CdsBaseType type = this.entity.findElement(n).filter(e -> e.getType().isSimple()).map(e -> ((CdsSimpleType)e.getType().as(CdsSimpleType.class)).getType()).orElse(null);
            return new PreparedCqnStmt.DataParam((String)n, type);
        }).collect(Collectors.toList()));
        Stream.Builder<String> builder = Stream.builder();
        builder.add("UPDATE");
        builder.add(this.tableName);
        builder.add("SET");
        SQLStatementBuilder.commaSeparated(this.update.elements().map(e -> this.sqlMapping.columnName((String)e) + " = ?")).forEach(builder::add);
        this.update.where().map(this.toSQL::toSQL).ifPresent(s -> {
            builder.add("WHERE");
            builder.add((String)s);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }
}

