/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.PathExpressionResolver;
import java.util.Collection;
import java.util.function.Supplier;

public class CqnNormalizer {
    private final CdsModel cdsModel;
    private final Supplier<SessionContext> sessionContextSupplier;
    private final DataStoreConfiguration config;
    private final CqnAnalyzer analyzer;
    private final SearchResolver searchResolver;

    public CqnNormalizer(Context context) {
        this.cdsModel = context.getCdsModel();
        this.sessionContextSupplier = context::getSessionContext;
        this.analyzer = CqnAnalyzer.create((CdsModel)this.cdsModel);
        this.config = context.getDataStoreConfiguration();
        this.searchResolver = context.getSearchResolver(this.cdsModel, this.sessionContextSupplier);
    }

    public CqnSelect normalize(CqnSelect select) {
        select = this.normalizeSubqueries(select);
        CdsStructuredType target = CqnStatementUtils.targetType((CdsModel)this.cdsModel, (CqnSelect)select);
        select = CqnStatementUtils.resolveStar((CqnSelect)select, (CdsStructuredType)target);
        boolean ignoreVirtualElements = Boolean.parseBoolean(this.config.getProperty("cds.sql.ignore-virtual-elements", "true"));
        select = ignoreVirtualElements ? CqnStatementUtils.removeVirtualElements((CqnSelect)select, (CdsStructuredType)target) : CqnStatementUtils.resolveVirtualElements((CqnSelect)select, (CdsStructuredType)target);
        select = (CqnSelect)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, (CqnStatement)select);
        select = CqnStatementUtils.resolveExpands((CqnSelect)select, (CdsStructuredType)target);
        select = CqnStatementUtils.unfoldInline((CqnSelect)select, (CdsStructuredType)target);
        select = this.searchResolver.resolve(select);
        select = CqnStatementUtils.simplify((CdsStructuredType)target, (CqnSelect)select);
        return select;
    }

    private CqnSelect normalizeSubqueries(CqnSelect select) {
        CqnSource source = select.from();
        if (!source.isSelect()) {
            return select;
        }
        select.search().ifPresent(s -> this.searchResolver.pushDownSearchToSubquery(select, select.from().asSelect()));
        CqnSelect inner = this.normalize(source.asSelect());
        SelectBuilder outerSelect = (SelectBuilder)Select.from((CqnSelect)inner);
        this.moveAllQueryPartsFromOldSelectToNewOuterSelect(select, outerSelect);
        return outerSelect;
    }

    private void moveAllQueryPartsFromOldSelectToNewOuterSelect(CqnSelect select, SelectBuilder<?> outer) {
        if (select.isDistinct()) {
            outer.distinct();
        }
        if (select.hasInlineCount()) {
            outer.inlineCount();
        }
        outer.columns(select.items());
        select.where().ifPresent(arg_0 -> outer.where(arg_0));
        select.search().ifPresent(s -> {
            Predicate searchExpression = (Predicate)s;
            Collection searchableElements = outer.searchableElements();
            outer.search(e -> searchExpression, (Iterable)searchableElements);
        });
        select.having().ifPresent(arg_0 -> outer.having(arg_0));
        outer.groupBy(select.groupBy());
        outer.orderBy(select.orderBy());
        select.limit().ifPresent(l -> outer.limit(l.top(), l.skip()));
        outer.excluding((Collection)select.excluding());
        select.getLock().ifPresent(l -> outer.lock(((Integer)l.timeout().get()).intValue()));
    }

    public CqnInsert normalize(CqnInsert insert) {
        insert = (CqnInsert)PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnXsert)insert);
        return insert;
    }

    public CqnUpsert normalize(CqnUpsert upsert) {
        upsert = (CqnUpsert)PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnXsert)upsert);
        return upsert;
    }

    public CqnUpdate normalize(CqnUpdate update) {
        update = PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnUpdate)update);
        CdsEntity target = this.analyzer.analyze(update.ref()).targetEntity();
        update = (CqnUpdate)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, (CqnStatement)update);
        return update;
    }

    public CqnDelete normalize(CqnDelete delete) {
        delete = PathExpressionResolver.resolvePath((CdsModel)this.cdsModel, (CqnDelete)delete);
        CdsEntity target = this.analyzer.analyze(delete.ref()).targetEntity();
        delete = (CqnDelete)CqnStatementUtils.resolveKeyPlaceholder((CdsStructuredType)target, (CqnStatement)delete);
        return delete;
    }
}

