/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.EntityCascader;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Insert;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeepInsertSplitter {
    private final CdsEntity entity;
    private final Map<String, List<Map<String, Object>>> insertEntries = new HashMap<String, List<Map<String, Object>>>();

    public DeepInsertSplitter(CdsModel model, String entityName) {
        this.entity = model.getEntity(entityName);
    }

    public List<Insert> split(List<Map<String, Object>> entries) {
        entries.forEach(entry -> this.flattenEntry(this.entity, (Map<String, Object>)entry));
        return this.computeInserts();
    }

    public List<Insert> split(Map<String, Object> entry) {
        this.flattenEntry(this.entity, entry);
        return this.computeInserts();
    }

    private List<Insert> computeInserts() {
        return this.insertEntries.entrySet().stream().map(e -> Insert.into((String)((String)e.getKey())).entries((Iterable)e.getValue())).collect(Collectors.toList());
    }

    private void flattenEntry(CdsEntity entity, Map<String, Object> entry) {
        HashMap flatEntry = new HashMap();
        String entityName = entity.getName();
        entry.forEach((elementName, value) -> {
            Optional assoc = entity.findAssociation(elementName);
            if (assoc.isPresent()) {
                if (value != null) {
                    CdsElement association = (CdsElement)assoc.get();
                    if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                        this.handleReverseAssociation(entity, association, entry, value);
                    } else {
                        Map<String, Object> targetValues = DeepInsertSplitter.asMap(entityName, association.getName(), value);
                        DeepInsertSplitter.assertInputDataContainsKeys(association, targetValues);
                        flatEntry.putAll(this.computeFkValues(association, targetValues));
                        if (DeepInsertSplitter.cascadeInsert(association)) {
                            CdsAssociationType assocType = (CdsAssociationType)association.getType();
                            this.flattenEntry(assocType.getTarget(), targetValues);
                        }
                    }
                }
            } else {
                flatEntry.put(elementName, value);
            }
        });
        this.insertEntries.computeIfAbsent(entity.getQualifiedName(), k -> new ArrayList()).add(flatEntry);
    }

    private void handleReverseAssociation(CdsEntity entity, CdsElement association, Map<String, Object> entry, Object targetVal) {
        if (DeepInsertSplitter.cascadeInsert(association)) {
            CdsAssociationType assoc = (CdsAssociationType)association.getType();
            Map fkValues = new OnConditionAnalyzer(association, true).getFkValues(entry);
            List<Map<String, Object>> targetValues = DeepInsertSplitter.asList(entity.getName(), association.getName(), targetVal);
            for (Map<String, Object> child : targetValues) {
                child.putAll(fkValues);
                this.flattenEntry(assoc.getTarget(), child);
            }
        } else {
            throw new UnsupportedOperationException("Cannot set reference " + entity.getQualifiedName() + "." + association.getName() + ". Reverse associations are not supported.");
        }
    }

    private static boolean cascadeInsert(CdsElement element) {
        return EntityCascader.isCascading(EntityCascader.CascadeType.INSERT, element);
    }

    private Map<String, Object> computeFkValues(CdsElement assoc, Map<String, Object> targetValues) {
        return new OnConditionAnalyzer(assoc, false).getFkValues(targetValues);
    }

    private static void assertInputDataContainsKeys(CdsElement association, Map<String, Object> targetValues) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        Set keyNames = CdsModelUtils.keyNames((CdsStructuredType)assoc.getTarget());
        if (!targetValues.keySet().containsAll(keyNames)) {
            throw new CdsDataException("Data set " + targetValues.keySet() + " for association " + association.getQualifiedName() + " does not contain values for all target entity keys " + keyNames + ".");
        }
        if (!DeepInsertSplitter.cascadeInsert(association) && !keyNames.equals(targetValues.keySet())) {
            throw new CdsDataException("Inserting/updating entity '" + assoc.getTarget() + "' via '" + association.getQualifiedName() + "' is not allowed. Please check the @cascade annotation.");
        }
    }

    private static Map<String, Object> asMap(String entityName, String associationName, Object value) {
        try {
            return (Map)value;
        }
        catch (ClassCastException ex) {
            throw DeepInsertSplitter.badValue(entityName, associationName, ex);
        }
    }

    private static List<Map<String, Object>> asList(String entityName, String associationName, Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        throw DeepInsertSplitter.badValue(entityName, associationName, null);
    }

    private static RuntimeException badValue(String entityName, String associationName, RuntimeException cause) {
        return new CdsDataException("Unexpected value: Entity '" + entityName + "' contains unexpected value for the association '" + associationName + "'. ", (Throwable)cause);
    }
}

