/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Streams;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.jdbc.hana.docstore.DocStoreUtils;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CqnValidatorImpl
implements CqnValidator {
    protected final CdsModel cdsModel;
    protected final CqnAnalyzer cqnAnalyzer;
    protected final DocStoreUtils docStoreUtils;

    public CqnValidatorImpl(CdsModel cdsModel) {
        this.cdsModel = cdsModel;
        this.cqnAnalyzer = CqnAnalyzer.create(() -> cdsModel);
        this.docStoreUtils = new DocStoreUtils(cdsModel);
    }

    @Override
    public void validate(CqnSelect query) {
        this.validate(query, CdsDataStoreConnector.Capabilities.ALL);
    }

    @Override
    public void validate(CqnSelect query, CdsDataStoreConnector.Capabilities capabilities) {
        CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.cdsModel, (CqnSelect)query);
        query.accept((CqnVisitor)new ValidateRefsVisitor(targetType));
        if (query.from().isRef()) {
            CdsEntity entity = CdsModelUtils.entity((CdsModel)this.cdsModel, (CqnStructuredTypeRef)query.from().asRef());
            if (!capabilities.supportsViewsWithParameters() && entity.isView() && entity.params().count() > 0L) {
                throw new UnsupportedOperationException("Parametrized views are not supported by this data store");
            }
        }
        query.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator(targetType)));
        query.having().ifPresent(h -> h.accept((CqnVisitor)new VirtualElementValidator(targetType)));
    }

    @Override
    public void validate(CqnInsert insert) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)insert)) {
            return;
        }
        this.validateElements(this.cqnAnalyzer.analyze(insert.ref()).targetEntity(), insert.elements());
    }

    @Override
    public void validate(CqnUpdate update) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)update)) {
            this.assertThatAllEntriesHaveSameStructure(update);
            return;
        }
        CdsEntity rowType = CdsModelUtils.entity((CdsModel)this.cdsModel, (CqnStructuredTypeRef)update.ref());
        update.accept((CqnVisitor)new ValidateRefsVisitor((CdsStructuredType)rowType));
        this.validateElements(this.cqnAnalyzer.analyze(update.ref()).targetEntity(), update.elements());
        CdsStructuredType targetType = CqnStatementUtils.rowType((CdsModel)this.cdsModel, (CqnSource)update.ref());
        update.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator(targetType)));
    }

    private void assertThatAllEntriesHaveSameStructure(CqnUpdate update) {
        Set elements = update.data().keySet();
        if (!update.entries().stream().allMatch(e -> e.keySet().equals(elements))) {
            String allElements = update.elements().collect(Collectors.joining(", ", "[", "]"));
            throw new UnsupportedOperationException("Each bulk update entry must contain values for the same elements " + allElements);
        }
    }

    private void validateElements(CdsEntity entity, Stream<String> usedElements) {
        Set allElements = this.elements("", (CdsStructuredType)entity).collect(Collectors.toSet());
        usedElements.forEach(e -> this.validateElement(entity.getQualifiedName(), (String)e, allElements));
    }

    private Stream<String> elements(String prefix, CdsStructuredType type) {
        return type.elements().flatMap(e -> this.elements(prefix, e.getName(), e.getType()));
    }

    private Stream<String> elements(String prefix, String name, CdsType type) {
        Stream<String> me = Stream.of(prefix + name);
        if (type.isSimple() || type.isArrayed() || type.isEnum()) {
            return me;
        }
        if (type.isStructured()) {
            return this.elements(prefix + name + ".", (CdsStructuredType)type.as(CdsStructuredType.class));
        }
        if (!type.isAssociation()) {
            throw new IllegalStateException("Element " + name + " has unexpected type " + type.getClass().getName());
        }
        Stream<String> subElements = this.generatedFkElements(name, (CdsAssociationType)type.as(CdsAssociationType.class)).map(fk -> prefix + fk);
        return Streams.concat((Stream[])new Stream[]{me, subElements});
    }

    private Stream<String> generatedFkElements(String name, CdsAssociationType type) {
        if (!type.onCondition().isPresent()) {
            CdsEntity target = type.getTarget();
            return target.concreteElements().filter(CdsElement::isKey).map(e -> name + "_" + e.getName());
        }
        return Stream.empty();
    }

    private void validateElement(String entityName, String element, Set<String> allElements) {
        if (!allElements.contains(element) && !allElements.contains(element.split("\\.")[0])) {
            throw new CqnValidationException("Element '" + element + "' does not exist in entity '" + entityName + "'");
        }
    }

    @Override
    public void validate(CqnDelete delete) {
        String entityName = delete.ref().firstSegment();
        this.getEntity(entityName);
        CdsStructuredType targetType = CqnStatementUtils.rowType((CdsModel)this.cdsModel, (CqnSource)delete.ref());
        delete.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator(targetType)));
    }

    private CdsEntity getEntity(String entityName) {
        return (CdsEntity)this.cdsModel.findEntity(entityName).orElseThrow(() -> new CqnValidationException("Entity '" + entityName + "' does not exist"));
    }

    private class VirtualElementValidator
    implements CqnVisitor {
        private CdsStructuredType root;

        public VirtualElementValidator(CdsStructuredType rowType) {
            this.root = rowType;
        }

        public void visit(CqnElementRef ref) {
            if ("$key".equals(ref.lastSegment()) || CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                return;
            }
            if (CdsModelUtils.element((CdsStructuredType)this.root, (CqnElementRef)ref).isVirtual()) {
                throw new IllegalArgumentException(String.format("Virtual element '%s' is not allowed in 'where' or 'having' clause", ref.displayName()));
            }
        }
    }

    private static class ValidateRefsVisitor
    implements CqnVisitor {
        private CdsStructuredType root;

        public ValidateRefsVisitor(CdsStructuredType rowType) {
            this.root = rowType;
        }

        public void visit(CqnElementRef ref) {
            try {
                if (!"$key".equals(ref.lastSegment()) && !CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                    CdsModelUtils.element((CdsStructuredType)this.root, (CqnElementRef)ref);
                }
            }
            catch (CdsElementNotFoundException e) {
                throw new CqnValidationException(e.getMessage());
            }
        }

        public void visit(CqnSortSpecification sortSpec) {
            sortSpec.item().accept((CqnVisitor)this);
        }
    }
}

