/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnSubQuery;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.util.CdsModelUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class DeleteCascader {
    private final CdsEntity entity;
    private final Set<String> visited = new HashSet<String>();
    private final LinkedList<CqnDelete> deletes = new LinkedList();
    private CqnStructuredTypeRef ref;
    private CqnPredicate filter;

    private DeleteCascader(CdsEntity entity) {
        this.entity = entity;
    }

    public static DeleteCascader create(CdsEntity entity) {
        return new DeleteCascader(entity);
    }

    public DeleteCascader from(CqnStructuredTypeRef ref) {
        this.ref = ref;
        return this;
    }

    public DeleteCascader where(Optional<CqnPredicate> filter) {
        filter.ifPresent(f -> f.accept(new CqnVisitor(){

            public void visit(CqnSubQuery query) {
                throw new UnsupportedOperationException("Cascading delete is not supported for where exists");
            }
        }));
        this.filter = filter.orElse(null);
        return this;
    }

    public void cascade(Consumer<CqnDelete> action) {
        StructuredType path = CQL.to((List)RefSegmentImpl.copy((List)this.ref.segments()));
        if (this.filter != null) {
            path.filter((CqnPredicate)this.ref.targetSegment().filter().map(f -> CQL.and((CqnPredicate)f, (CqnPredicate)this.filter)).orElse((Predicate)this.filter));
        }
        this.cascade(path, this.entity);
        this.deletes.forEach(d -> action.accept((CqnDelete)d));
    }

    private void cascade(StructuredType<?> path, CdsEntity entity) {
        entity.associations().filter(a -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)a)).forEach(assoc -> this.cascade(path, (CdsElement)assoc));
    }

    private void cascade(StructuredType<?> path, CdsElement association) {
        CdsAssociationType assocType = (CdsAssociationType)association.getType();
        CdsEntity target = assocType.getTarget();
        if (!this.visited.add(association.getQualifiedName())) {
            throw new UnsupportedOperationException("Cascading delete is not supported for cyclic models");
        }
        StructuredType p = path.to(association.getName());
        this.deletes.addFirst((CqnDelete)Delete.from((StructuredType)p));
        this.cascade(p, target);
    }
}

