/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.sap.cds.CdsDataStore;
import com.sap.cds.Result;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityCascader {
    private final CdsDataStore dataStore;
    private final CdsEntity rootEntity;
    private final Map<String, Object> paramValues = new HashMap<String, Object>();
    private final Set<EntityKeys> visited = new HashSet<EntityKeys>();
    private CqnPredicate rootFilter;

    private EntityCascader(CdsDataStore dataStore, CdsEntity rootEntity) {
        this.dataStore = dataStore;
        this.rootEntity = rootEntity;
    }

    public static EntityCascader from(CdsDataStore dataStore, CdsEntity entity) {
        return new EntityCascader(dataStore, entity);
    }

    public EntityCascader where(Optional<CqnPredicate> pred) {
        return this.where((CqnPredicate)pred.orElse(null));
    }

    public EntityCascader where(CqnPredicate pred) {
        this.rootFilter = pred;
        return this;
    }

    public EntityCascader with(Map<String, Object> paramValues) {
        this.paramValues.clear();
        this.paramValues.putAll(paramValues);
        return this;
    }

    public Set<EntityKeys> cascade(CdsModelUtils.CascadeType cascadeType) {
        this.cascadeRoot((d, a) -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)cascadeType, (CdsElement)a), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    @VisibleForTesting
    public Set<EntityKeys> cascade(Predicate<CdsAssociationType> assocFilter) {
        this.cascadeRoot((d, a) -> assocFilter.test((CdsAssociationType)a.getType()), Collections.emptyMap());
        return Collections.unmodifiableSet(this.visited);
    }

    public static Stream<EntityOperation> cascadeDelete(CdsDataStore dataStore, EntityKeys targetEntity) {
        return EntityCascader.from(dataStore, targetEntity.entity).where((CqnPredicate)ExpressionImpl.matching((Map)((Object)targetEntity))).cascade(CdsModelUtils.CascadeType.DELETE).stream().map(k -> EntityOperation.delete(k, dataStore.getSessionContext()));
    }

    private void cascadeRoot(BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        this.cascade(this.rootEntity, this.rootFilter, this.paramValues, assocFilter, data);
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> data) {
        entity.associations().filter(a -> assocFilter.test(data, (CdsElement)a)).forEach(assoc -> this.cascade(entity, filter, paramValues, assocFilter, (CdsElement)assoc, data));
    }

    private void cascade(CdsEntity entity, CqnPredicate filter, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, CdsElement association, Map<String, Object> data) {
        String assocName = association.getName();
        CdsAssociationType assocType = (CdsAssociationType)association.getType();
        StructuredType path = CQL.entity((String)entity.getQualifiedName()).filter(filter).to(assocName);
        CdsEntity targetEntity = assocType.getTarget();
        if (CdsModelUtils.isSingleValued((CdsType)assocType)) {
            this.cascadeToOne(path, entity, targetEntity, association, paramValues, assocFilter, data);
        } else {
            List<Map<String, Object>> d = EntityCascader.getList(data, assocName);
            this.cascadeToMany(path, targetEntity, association, paramValues, assocFilter, d);
        }
    }

    private static Map<String, Object> getMap(Map<String, Object> data, String key) {
        return data.getOrDefault(key, Collections.emptyMap());
    }

    private static List<Map<String, Object>> getList(Map<String, Object> data, String key) {
        return (List)data.get(key);
    }

    private void cascadeToOne(StructuredType<?> path, CdsEntity parent, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, Map<String, Object> parentData) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        Result targetData = this.dataStore.execute(selectTargetKeys, paramValues);
        ArrayList targetKeys = new ArrayList();
        Map<String, Object> newData = EntityCascader.getMap(parentData, association.getName());
        targetData.stream().map(data -> EntityKeys.keys(target, (Map<String, Object>)data)).forEach(targetKeys::add);
        targetKeys.stream().filter(this::notVisited).forEach(keys -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)keys)), Collections.emptyMap(), assocFilter, newData));
    }

    private void cascadeToMany(StructuredType<?> path, CdsEntity target, CdsElement association, Map<String, Object> paramValues, BiPredicate<Map<String, Object>, CdsElement> assocFilter, List<Map<String, Object>> newData) {
        Select<?> selectTargetKeys = this.selectTargetKeys(association, path);
        Set targetKeys = this.dataStore.execute(selectTargetKeys, paramValues).stream().map(row -> EntityKeys.keys(target, (Map<String, Object>)row)).collect(Collectors.toSet());
        targetKeys.stream().filter(this::notVisited).forEach(k -> this.cascade(target, (CqnPredicate)ExpressionImpl.matching((Map)((Object)k)), Collections.emptyMap(), assocFilter, Collections.emptyMap()));
    }

    private Select<?> selectTargetKeys(CdsElement association, StructuredType<?> path) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        return SelectBuilder.from(path).columns(assoc.getTarget().keyElements().flatMap(x$0 -> EntityCascader.slis(x$0, new String[0])));
    }

    private static Stream<CqnSelectListItem> slis(CdsElement keyElement, String ... association) {
        String[] path = Arrays.copyOf(association, association.length + 1);
        path[path.length - 1] = keyElement.getName();
        if (keyElement.getType().isAssociation()) {
            return ((CdsAssociationType)keyElement.getType().as(CdsAssociationType.class)).keys().flatMap(k -> EntityCascader.slis(k, path));
        }
        return Stream.of(EntityCascader.sli(path));
    }

    private static CqnSelectListItem sli(String ... path) {
        ElementRef element = ElementRefImpl.element((String[])path);
        SelectListValueBuilder sli = SelectListValueBuilder.select((CqnValue)element);
        if (path.length > 1) {
            String alias = Arrays.stream(path).collect(Collectors.joining("."));
            return sli.as(alias).build();
        }
        return sli.build();
    }

    private boolean notVisited(EntityKeys keys) {
        return this.visited.add(keys);
    }

    public static class EntityKeys
    extends ForwardingMap<String, Object> {
        private final CdsEntity entity;
        private final Map<String, Object> keys;

        private EntityKeys(CdsEntity entity, Map<String, Object> keys) {
            this.entity = entity;
            this.keys = keys;
        }

        public static EntityKeys keys(CdsEntity entity, Map<String, Object> data) {
            Map keyValues = DataUtils.keyValues((CdsEntity)entity, data);
            keyValues.remove("IsActiveEntity");
            if (keyValues.values().contains(null)) {
                throw new CdsDataException("Key values of entity " + entity + " must not be null");
            }
            return new EntityKeys(entity, keyValues);
        }

        public Map<String, Object> keys() {
            return Collections.unmodifiableMap(this.keys);
        }

        public CdsEntity entity() {
            return this.entity;
        }

        protected Map<String, Object> delegate() {
            return this.keys;
        }

        public int hashCode() {
            return Objects.hash(this.entity.getQualifiedName(), this.keys);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityKeys other = (EntityKeys)((Object)obj);
            if (!this.entity.getQualifiedName().equals(other.entity.getQualifiedName())) {
                return false;
            }
            return this.keys.equals(other.keys);
        }

        public String toString() {
            return this.entity.getQualifiedName() + "[" + this.keys.toString() + "]";
        }
    }

    public static class EntityOperation
    extends ForwardingMap<String, Object> {
        private final EntityKeys targetKeys;
        private final Map<String, Object> data = new HashMap<String, Object>();
        private final Set<String> updated = new HashSet<String>();
        private final boolean root;
        private Map<String, Object> updateData;
        private SessionContext sessionContext;
        private long updateCount = 0L;
        private Operation operation;

        private EntityOperation(EntityKeys targetKeys, Operation operation, SessionContext sessionContext, boolean root) {
            this.targetKeys = targetKeys;
            this.data.putAll((Map<String, Object>)((Object)targetKeys));
            this.operation = operation;
            this.sessionContext = sessionContext;
            this.root = root;
        }

        public static EntityOperation root(EntityKeys entity, SessionContext sessionContext) {
            return new EntityOperation(entity, Operation.UPDATE, sessionContext, true);
        }

        public static EntityOperation nop(EntityKeys entity, SessionContext sessionContext) {
            return new EntityOperation(entity, Operation.NOP, sessionContext, false);
        }

        public static EntityOperation nop(EntityKeys entity, Map<String, Object> data, SessionContext sessionContext) {
            return EntityOperation.nop(entity, sessionContext).data(data, Collections.emptyMap());
        }

        public static EntityOperation upsert(EntityKeys entity, Map<String, Object> data, Map<String, Object> fkValues, SessionContext sessionContext) {
            return new EntityOperation(entity, Operation.UPSERT, sessionContext, false).update(data, fkValues);
        }

        public static EntityOperation insert(EntityKeys entity, Map<String, Object> data, Map<String, Object> fkValues, SessionContext sessionContext) {
            return new EntityOperation(entity, Operation.INSERT, sessionContext, false).data(data, fkValues);
        }

        public static EntityOperation delete(EntityKeys targetKeys, SessionContext sessionContext) {
            return new EntityOperation(targetKeys, Operation.DELETE, sessionContext, false);
        }

        public CdsEntity targetEntity() {
            return this.targetKeys.entity;
        }

        public Operation operation() {
            return this.operation;
        }

        public boolean isRootOp() {
            return this.root;
        }

        public long updateCount() {
            return this.updateCount;
        }

        private EntityOperation data(Map<String, Object> data, Map<String, Object> fkValues) {
            this.updateData = data;
            this.data.putAll(this.flattenData(this.targetKeys.entity, data));
            this.data.putAll(fkValues);
            return this;
        }

        public boolean inserted(Map<String, Object> data) {
            if (!data.isEmpty()) {
                this.updateData.putAll(Maps.filterKeys(data, k -> !this.data.keySet().contains(k)));
                this.updateCount = 1L;
                return true;
            }
            return false;
        }

        public boolean updated(Map<String, Object> data, long updateCount) {
            this.updateCount = updateCount;
            if (!data.isEmpty()) {
                this.updateData.putAll(Maps.filterKeys(data, k -> !this.data.keySet().contains(k)));
                return true;
            }
            return false;
        }

        public EntityOperation deleted() {
            return this;
        }

        public EntityOperation updateToNull(Set<String> keys) {
            for (String key : keys) {
                this.data.put(key, null);
                this.updated.add(key);
                this.operation = Operation.UPDATE;
            }
            return this;
        }

        public EntityOperation update(Map<String, Object> updateData, Map<String, Object> fkValues) {
            this.mergeData(updateData);
            Map<String, Object> flattenedData = this.flattenData(this.targetEntity(), updateData);
            flattenedData.putAll(fkValues);
            flattenedData.forEach((key, newValue) -> {
                boolean valuePresent = this.data.containsKey(key);
                Object oldVal = this.data.put((String)key, newValue);
                if (!valuePresent || !Objects.equals(oldVal, newValue)) {
                    Object keyVal;
                    this.updated.add((String)key);
                    if (this.operation == Operation.NOP) {
                        this.operation = Operation.UPDATE;
                    }
                    if ((keyVal = this.targetKeys.get(key)) != null && !keyVal.equals(newValue)) {
                        throw new CdsDataException("Key values cannot be changed");
                    }
                }
            });
            return this;
        }

        private void mergeData(Map<String, Object> data) {
            if (this.updateData == null) {
                this.updateData = data;
            } else {
                this.updateData.putAll(data);
            }
        }

        private Map<String, Object> flattenData(CdsEntity entity, Map<String, Object> updateData) {
            HashMap<String, Object> copy = new HashMap<String, Object>(updateData);
            EntityOperation.associationsInData(entity, updateData).forEach(a -> this.flattenData((CdsElement)a, (Map<String, Object>)copy));
            return copy;
        }

        private static Stream<CdsElement> associationsInData(CdsEntity e, Map<String, Object> d) {
            return e.associations().filter(a -> d.keySet().contains(a.getName()));
        }

        private void flattenData(CdsElement association, Map<String, Object> data) {
            if (CdsModelUtils.isReverseAssociation((CdsElement)association)) {
                data.remove(association.getName());
            } else {
                Map targetValues = (Map)data.remove(association.getName());
                if (targetValues == null) {
                    data.putAll(EntityOperation.computeFkValues(association, Collections.emptyMap(), this.sessionContext));
                } else if (targetValues.keySet().containsAll(CdsModelUtils.targetKeys((CdsElement)association))) {
                    data.putAll(EntityOperation.computeFkValues(association, targetValues, this.sessionContext));
                }
            }
        }

        private static Map<String, Object> computeFkValues(CdsElement association, Map<String, Object> targetValues, SessionContext sessionContext) {
            return new OnConditionAnalyzer(association, CdsModelUtils.isReverseAssociation((CdsElement)association), sessionContext).getFkValues(targetValues);
        }

        public EntityKeys targetKeys() {
            return this.targetKeys;
        }

        public Map<String, Object> updateValues() {
            HashMap<String, Object> values = new HashMap<String, Object>(Maps.filterKeys(this.data, this.updated::contains));
            values.putAll((Map<String, Object>)((Object)this.targetKeys));
            return values;
        }

        protected Map<String, Object> delegate() {
            return this.data;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetKeys, this.data});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            EntityOperation other = (EntityOperation)((Object)obj);
            if (!this.targetKeys.equals((Object)other.targetKeys)) {
                return false;
            }
            return this.data.equals(other.data);
        }

        public String toString() {
            return (Object)((Object)this.operation) + " " + (Object)((Object)this.targetKeys) + ": " + this.data.toString();
        }

        public static enum State {
            UNCHANGED,
            INSERTED,
            UPDATED,
            DELETED;

        }

        public static enum Operation {
            NOP,
            INSERT,
            UPDATE,
            UPSERT,
            DELETE;

        }
    }

    public static class EntityOperations {
        private final List<EntityOperation> operations = new ArrayList<EntityOperation>();
        private final List<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();

        public void entries(List<Map<String, Object>> entries) {
            this.entries.addAll(entries);
        }

        public List<Map<String, Object>> entries() {
            return this.entries;
        }

        public boolean add(EntityOperation op) {
            return this.operations.add(op);
        }

        public Stream<EntityOperation> rootOps() {
            return this.operations.stream().filter(EntityOperation::isRootOp);
        }

        public Stream<EntityOperation> filter(EntityOperation.Operation opType) {
            return this.operations.stream().filter((? super T d) -> d.operation() == opType);
        }

        public long[] updateCount() {
            long[] updateCount = this.rootOps().mapToLong(EntityOperation::updateCount).toArray();
            if (updateCount.length == 0) {
                return new long[]{0L};
            }
            return updateCount;
        }
    }
}

