/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.sap.cds.CdsDataStore;
import com.sap.cds.NonUniqueResultException;
import com.sap.cds.Row;
import com.sap.cds.impl.Lazy;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelect;
import java.util.List;
import java.util.Map;

public class LazyRowImpl
extends ForwardingMap<String, Object>
implements Row,
Lazy {
    private final CdsDataStore dataStore;
    private final CqnSelect query;
    private boolean loaded;
    private Row row;

    public LazyRowImpl(CdsDataStore dataStore, CqnSelect query) {
        this.dataStore = dataStore;
        this.query = query;
    }

    private Row data() {
        if (!this.loaded) {
            this.load();
        }
        return this.row;
    }

    public String toJson() {
        return this.row != null ? this.row.toJson() : null;
    }

    public String toString() {
        return this.toJson();
    }

    protected Map<String, Object> delegate() {
        return this.data();
    }

    public <T> T as(Class<T> type) {
        return (T)this.data().as(type);
    }

    public void load() {
        List result = this.dataStore.execute(this.query, new Object[0]).list();
        this.loaded = true;
        int resultSize = result.size();
        if (resultSize == 1) {
            this.row = (Row)result.get(0);
        } else if (resultSize > 1) {
            throw new NonUniqueResultException("Query for single-valued association returned multiple rows");
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Object loadData() {
        Row data = this.data();
        return data != null ? Maps.newHashMap((Map)data) : null;
    }

    public StructuredType<?> ref() {
        return this.data().ref();
    }
}

