/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.AbstractSearchResolver;
import com.sap.cds.impl.SearchResolver;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.function.Supplier;

public class LocalizedViewSearchResolver
extends AbstractSearchResolver
implements SearchResolver {
    private final CdsModel model;
    private final Supplier<SessionContext> sessionContextSupplier;

    public LocalizedViewSearchResolver(CdsModel model, Supplier<SessionContext> sessionContextSupplier) {
        this.model = model;
        this.sessionContextSupplier = sessionContextSupplier;
    }

    public CqnSelect resolve(CqnSelect select) {
        select.search().ifPresent(expression -> {
            boolean languageIsGiven;
            boolean bl = languageIsGiven = this.sessionContextSupplier != null && this.sessionContextSupplier.get().getLocale() != null;
            if (languageIsGiven) {
                CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
                Collection searchableRefs = LocalizedViewSearchResolver.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
                this.resolveUsingLocalizedViewWithLike(select, (CqnPredicate)expression, targetType, searchableRefs, false);
            }
        });
        return select;
    }
}

