/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.draft;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.qat.TableNameResolver;
import com.sap.cds.impl.sql.SqlMapping;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Comparator;
import java.util.stream.Collectors;

public class DraftUtils {
    private static final String DRAFT_ANNOTATION = "odata.draft.enabled";
    private static final String DRAFT_PREPARE_ANNOTATION = "Common.DraftNode.PreparationAction";
    private static final String DRAFT = "_drafts";

    public static boolean isDraftEnabled(CdsStructuredType targetType) {
        return (Boolean)targetType.getAnnotationValue(DRAFT_ANNOTATION, (Object)false) != false || targetType.findAnnotation(DRAFT_PREPARE_ANNOTATION).isPresent();
    }

    public static boolean isDraftView(CdsStructuredType type) {
        return type.getQualifiedName().endsWith(DRAFT);
    }

    public static String activeEntity(Context context, CdsEntity cdsEntity) {
        TableNameResolver tableResolver = context.getDbContext().getTableResolver();
        String draftEntityName = cdsEntity.getQualifiedName() + DRAFT;
        String draftTable = tableResolver.tableName(context, context.getCdsModel().getEntity(draftEntityName));
        String table = tableResolver.tableName(context, cdsEntity);
        return "(SELECT ACTIVE.*, true as IsActiveEntity, false as HasActiveEntity, COALESCE(DRAFT.HasActiveEntity, false) as HasDraftEntity, DRAFT.DraftAdministrativeData_DraftUUID as DraftAdministrativeData_DraftUUID from " + table + " ACTIVE left outer join " + draftTable + " DRAFT on " + DraftUtils.on(cdsEntity) + ")";
    }

    private static String on(CdsEntity cdsEntity) {
        return cdsEntity.concreteNonAssociationElements().filter(e -> e.isKey()).filter(e -> !"IsActiveEntity".equals(e.getName())).sorted(Comparator.comparing(CdsElement::getName)).map(SqlMapping::columnName).map(n -> "ACTIVE." + n + " = DRAFT." + n).collect(Collectors.joining(" AND "));
    }
}

